/*
 * Decompiled with CFR 0.152.
 */
package brennus.asm;

import brennus.ImmutableList;
import brennus.MethodContext;
import brennus.asm.ASMMethodGenerator;
import brennus.asm.MethodByteCodeContext;
import brennus.model.CallConstructorExpression;
import brennus.model.CallConstructorStatement;
import brennus.model.ExistingType;
import brennus.model.Expression;
import brennus.model.Field;
import brennus.model.FutureType;
import brennus.model.MemberFlags;
import brennus.model.Method;
import brennus.model.Protection;
import brennus.model.Statement;
import brennus.model.Type;
import java.util.Arrays;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.CheckClassAdapter;

public class ASMTypeGenerator {
    public byte[] generate(FutureType futureType) {
        ClassNode classNode = new ClassNode();
        classNode.version = 50;
        classNode.access = 33;
        classNode.sourceFile = futureType.getSourceFile();
        classNode.name = futureType.getClassIdentifier();
        classNode.superName = futureType.getExtending().getClassIdentifier();
        if (classNode.name.indexOf(36) != -1) {
            String declaringClass;
            classNode.outerClass = declaringClass = classNode.name.substring(0, classNode.name.lastIndexOf("$"));
        }
        ImmutableList fields = futureType.getFields();
        for (Field field : fields) {
            classNode.fields.add(new FieldNode(MethodByteCodeContext.getAccess(field.getFlags()), field.getName(), field.getSignature(), null, null));
        }
        ImmutableList staticFields = futureType.getStaticFields();
        for (Field field : staticFields) {
            classNode.fields.add(new FieldNode(MethodByteCodeContext.getAccess(field.getFlags()), field.getName(), field.getSignature(), null, null));
        }
        ImmutableList constructors = futureType.getConstructors();
        if (constructors.isEmpty()) {
            constructors = ImmutableList.from(Arrays.asList(new Method(futureType.getName(), new MemberFlags(false, false, Protection.PUBLIC), (Type)ExistingType.VOID, "<init>", ImmutableList.empty(), ImmutableList.from(Arrays.asList(new CallConstructorStatement(0, (Expression)new CallConstructorExpression(ImmutableList.empty())))), false)));
        }
        for (Method method : constructors) {
            classNode.methods.add(this.getMethodNode(futureType, method));
        }
        for (Method method : futureType.getMethods()) {
            classNode.methods.add(this.getMethodNode(futureType, method));
        }
        for (Method method : futureType.getStaticMethods()) {
            classNode.methods.add(this.getMethodNode(futureType, method));
        }
        ClassWriter cw = new ClassWriter(3);
        CheckClassAdapter cv = new CheckClassAdapter((ClassVisitor)cw, true);
        classNode.accept((ClassVisitor)cv);
        return cw.toByteArray();
    }

    private MethodNode getMethodNode(FutureType futureType, Method method) {
        MethodContext methodContext = new MethodContext(futureType, method);
        ASMMethodGenerator statementVisitor = new ASMMethodGenerator(methodContext);
        for (Statement statement : method.getStatements()) {
            statementVisitor.visit(statement);
        }
        MethodNode methodNode = statementVisitor.getMethodNode();
        return methodNode;
    }
}

