/*
 * Decompiled with CFR 0.152.
 */
package brennus.asm;

import brennus.ImmutableList;
import brennus.MethodContext;
import brennus.model.BoxingTypeConversion;
import brennus.model.CastTypeConversion;
import brennus.model.ExistingType;
import brennus.model.MemberFlags;
import brennus.model.Method;
import brennus.model.Parameter;
import brennus.model.PrimitiveType;
import brennus.model.Type;
import brennus.model.TypeConversion;
import brennus.model.TypeConversionVisitor;
import brennus.model.UnboxingTypeConversion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.ASMifierMethodVisitor;

class MethodByteCodeContext
implements Opcodes {
    private static final Logger logger = Logger.getLogger(MethodByteCodeContext.class.getName());
    private final MethodContext methodContext;
    private final MethodNode methodNode;
    private int maxv = 0;
    private int stack = 0;
    private int indent = 0;
    private ASMifierMethodVisitor methodVisitor = new ASMifierMethodVisitor();
    private int currentOp;
    private Map<String, LabelNode> namedLabels = new HashMap<String, LabelNode>();
    private Set<String> definedNamedLabels = new HashSet<String>();
    private int currentLocalVariableByteCodeIndex = 0;
    private List<Integer> localVarIndexToBytecodeIndex = new ArrayList<Integer>();
    private List<Integer> paramIndexToBytecodeIndex = new ArrayList<Integer>();

    public static int getAccess(MemberFlags flags) {
        int acc = (flags.isStatic() ? 8 : 0) | (flags.isFinal() ? 16 : 0);
        switch (flags.getProtection()) {
            case PRIVATE: {
                return acc | 2;
            }
            case PUBLIC: {
                return acc | 1;
            }
            case PROTECTED: {
                return acc | 4;
            }
            case DEFAULT: {
                return acc;
            }
        }
        throw new RuntimeException("Unexpected " + flags.getProtection());
    }

    MethodByteCodeContext(MethodContext methodContext) {
        Method method = methodContext.getMethod();
        logger.fine(method.toString());
        this.methodNode = new MethodNode(MethodByteCodeContext.getAccess(method.getFlags()), method.getName(), method.getSignature(), null, null);
        this.methodContext = methodContext;
        ImmutableList parameters = methodContext.getMethod().getParameters();
        if (!methodContext.getMethod().isStatic()) {
            this.currentLocalVariableByteCodeIndex = 1;
        }
        for (Parameter parameter : parameters) {
            this.paramIndexToBytecodeIndex.add(this.currentLocalVariableByteCodeIndex);
            this.incLocalVarIndex(parameter.getType());
        }
    }

    public void addInstruction(AbstractInsnNode insnNode, Object ... comments) {
        this.methodNode.instructions.add(insnNode);
        if (logger.isLoggable(Level.FINE)) {
            String s = "";
            insnNode.accept((MethodVisitor)this.methodVisitor);
            List text = this.methodVisitor.getText();
            while (this.currentOp < text.size()) {
                String t = (String)text.get(this.currentOp);
                while (t.length() > 0) {
                    String current;
                    int i = t.indexOf(10);
                    if (i >= 0) {
                        current = t.substring(0, i);
                        t = t.substring(i + 1);
                    } else {
                        current = t;
                        t = "";
                    }
                    s = s + this.indent() + current;
                    if (comments != null && comments.length > 0) {
                        s = s + " //";
                        for (Object c : comments) {
                            s = s + " " + c;
                        }
                    }
                    if (t.length() <= 0) continue;
                    s = s + "\n";
                }
                ++this.currentOp;
            }
            logger.fine(s);
        }
    }

    public void incIndent(Object ... comments) {
        ++this.indent;
        if (logger.isLoggable(Level.FINE) && comments.length > 0) {
            String log = this.indent() + "//";
            for (Object object : comments) {
                log = log + " " + object;
            }
            logger.fine(log);
        }
    }

    public void decIndent() {
        --this.indent;
    }

    private String indent() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public void loadThis(Object ... comments) {
        this.load(25, 0, comments);
    }

    public void load(Type type, int i, Object ... comments) {
        this.load(this.getLoad(type), i, comments);
    }

    public void aload(Type type, Object ... comments) {
        ++this.stack;
        this.addInstruction((AbstractInsnNode)new InsnNode(this.getALoad(type)), comments);
    }

    private void load(int load, int i, Object ... comments) {
        this.maxv = Math.max(this.maxv, i + 1);
        ++this.stack;
        this.addInstruction((AbstractInsnNode)new VarInsnNode(load, i), comments);
    }

    private int getALoad(Type type) {
        if (type.isPrimitive()) {
            switch (type.getClassIdentifier().charAt(0)) {
                case 'I': 
                case 'Z': {
                    return 46;
                }
                case 'J': {
                    return 47;
                }
                case 'F': {
                    return 48;
                }
                case 'D': {
                    return 49;
                }
            }
            throw new RuntimeException("Unsupported " + type);
        }
        return 50;
    }

    private int getLoad(Type type) {
        if (type.isPrimitive()) {
            switch (type.getClassIdentifier().charAt(0)) {
                case 'I': 
                case 'Z': {
                    return 21;
                }
                case 'J': {
                    return 22;
                }
                case 'F': {
                    return 23;
                }
                case 'D': {
                    return 24;
                }
            }
            throw new RuntimeException("Unsupported " + type);
        }
        return 25;
    }

    public void store(Type type, int i, Object ... comments) {
        this.store(this.getStore(type), i, comments);
    }

    private void store(int store, int i, Object ... comments) {
        this.maxv = Math.max(this.maxv, i + 1);
        this.addInstruction((AbstractInsnNode)new VarInsnNode(store, i), comments);
    }

    private int getStore(Type type) {
        if (type.isPrimitive()) {
            switch (type.getClassIdentifier().charAt(0)) {
                case 'I': 
                case 'Z': {
                    return 54;
                }
                case 'J': {
                    return 55;
                }
                case 'F': {
                    return 56;
                }
                case 'D': {
                    return 57;
                }
            }
            throw new RuntimeException("Unsupported " + type);
        }
        return 58;
    }

    public MethodNode getMethodNode() {
        if (this.methodContext.getReturnType().equals(ExistingType.VOID)) {
            this.addInstruction((AbstractInsnNode)new InsnNode(177), "end of method");
        }
        this.methodNode.visitMaxs(Math.max(1, this.maxv) + this.stack, Math.max(this.maxv + 1, this.currentLocalVariableByteCodeIndex));
        for (String label : this.namedLabels.keySet()) {
            if (this.definedNamedLabels.contains(label)) continue;
            throw new RuntimeException("\"goto " + label + "\" without corresponding \"" + label + ":\"");
        }
        return this.methodNode;
    }

    public void unbox(PrimitiveType primitiveType, Object ... comment) {
        String boxedClassIdentifier = primitiveType.getBoxedType().getClassIdentifier();
        this.addInstruction((AbstractInsnNode)new TypeInsnNode(192, boxedClassIdentifier), this.addComment(comment, "unboxing", primitiveType));
        this.addInstruction((AbstractInsnNode)new MethodInsnNode(182, boxedClassIdentifier, primitiveType.getName() + "Value", "()" + primitiveType.getClassIdentifier()), this.addComment(comment, "unboxing", primitiveType));
    }

    private Object[] addComment(Object[] comment, Object ... moreComment) {
        Object[] result = Arrays.copyOf(comment, comment.length + moreComment.length);
        for (int i = 0; i < moreComment.length; ++i) {
            Object object;
            result[comment.length + i] = object = moreComment[i];
        }
        return result;
    }

    public void box(PrimitiveType primitiveType, Object ... comment) {
        this.addInstruction((AbstractInsnNode)new MethodInsnNode(184, primitiveType.getBoxedType().getClassIdentifier(), "valueOf", "(" + primitiveType.getSignature() + ")" + primitiveType.getBoxedType().getSignature()), this.addComment(comment, "unboxing", primitiveType));
    }

    public void cast(Type type, Object ... comments) {
        this.addInstruction((AbstractInsnNode)new TypeInsnNode(192, type.getClassIdentifier()), comments);
    }

    public void handleConversion(Type expressionType, Type returnType, final Object ... comment) {
        TypeConversion typeConversion = this.methodContext.getTypeConversion(expressionType, returnType);
        typeConversion.accept(new TypeConversionVisitor(){

            public void visit(UnboxingTypeConversion unboxingTypeConversion) {
                MethodByteCodeContext.this.unbox(unboxingTypeConversion.getPrimitiveType(), comment);
            }

            public void visit(BoxingTypeConversion boxingTypeConversion) {
                MethodByteCodeContext.this.box(boxingTypeConversion.getPrimitiveType(), comment);
            }

            public void visit(CastTypeConversion castTypeConversion) {
                MethodByteCodeContext.this.cast(castTypeConversion.getType(), comment);
            }
        });
    }

    public void push(int bipush, int intValue, Object ... comments) {
        ++this.stack;
        this.addInstruction((AbstractInsnNode)new IntInsnNode(16, intValue), comments);
    }

    public void ldc(Object value, Object ... comments) {
        ++this.stack;
        this.addInstruction((AbstractInsnNode)new LdcInsnNode(value), comments);
    }

    public void addReturn(Type returnType, Object ... comments) {
        this.addInstruction((AbstractInsnNode)new InsnNode(this.getReturn(returnType)), comments);
    }

    private int getReturn(Type type) {
        if (type.isPrimitive()) {
            switch (type.getClassIdentifier().charAt(0)) {
                case 'I': 
                case 'Z': {
                    return 172;
                }
                case 'J': {
                    return 173;
                }
                case 'F': {
                    return 174;
                }
                case 'D': {
                    return 175;
                }
            }
            throw new RuntimeException("Unsupported " + type + " " + type.getClassIdentifier().charAt(0));
        }
        return 176;
    }

    public void addLineNumber(int line, Object ... comments) {
        if (line != 0) {
            LabelNode labelNode = new LabelNode(new Label());
            this.addLabel(line, labelNode, this.addComment(comments, "line", line));
        }
    }

    public void addLabel(int line, LabelNode label, Object ... comments) {
        this.addInstruction((AbstractInsnNode)label, comments);
        if (line != 0) {
            this.addInstruction((AbstractInsnNode)new LineNumberNode(line, label), comments);
        }
    }

    public void addLabel(LabelNode label, Object ... comments) {
        this.addInstruction((AbstractInsnNode)label, comments);
    }

    public void addIConst0(Object ... comment) {
        ++this.stack;
        this.addInstruction((AbstractInsnNode)new InsnNode(3), comment);
    }

    public void addIConst1(Object ... comment) {
        ++this.stack;
        this.addInstruction((AbstractInsnNode)new InsnNode(4), comment);
    }

    public LabelNode getLabelForSwitchGotoCase(String name) {
        return this.getLabel(name);
    }

    private LabelNode getLabel(String name) {
        LabelNode labelNode = this.namedLabels.get(name);
        if (labelNode == null) {
            labelNode = new LabelNode();
            this.namedLabels.put(name, labelNode);
        }
        return labelNode;
    }

    public void addNamedLabel(int line, String name) {
        LabelNode labelNode = this.getLabel(name);
        this.addLabel(line, labelNode, name + ":");
        this.definedNamedLabels.add(name);
    }

    public void gotoLabel(String name) {
        LabelNode labelNode = this.getLabel(name);
        this.addInstruction((AbstractInsnNode)new JumpInsnNode(167, labelNode), "goto " + name);
    }

    public int getLocalVariableByteCodeIndex(int varIndex) {
        return this.localVarIndexToBytecodeIndex.get(varIndex);
    }

    public void defineLocalVar(Type type, String name, int index) {
        this.localVarIndexToBytecodeIndex.add(this.currentLocalVariableByteCodeIndex);
        this.incLocalVarIndex(type);
    }

    private void incLocalVarIndex(Type type) {
        if (!type.isPrimitive()) {
            ++this.currentLocalVariableByteCodeIndex;
        } else {
            switch (type.getClassIdentifier().charAt(0)) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    ++this.currentLocalVariableByteCodeIndex;
                    break;
                }
                case 'D': 
                case 'J': {
                    this.currentLocalVariableByteCodeIndex += 2;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported " + type);
                }
            }
        }
    }

    public int getParamByteCodeIndex(int paramIndex) {
        return this.paramIndexToBytecodeIndex.get(paramIndex);
    }

    public void dup(Object ... comments) {
        this.addInstruction((AbstractInsnNode)new InsnNode(89), comments);
        ++this.stack;
    }

    public Else ifCondElse(int jumpInst, Object ... comment) {
        return new Else(jumpInst, comment);
    }

    public void addBool(boolean b, Object ... comment) {
        if (b) {
            this.addIConst1("bool literal", b);
        } else {
            this.addIConst0("bool literal", b);
        }
    }

    public void newArray(Type type, Object ... comments) {
        block11: {
            block10: {
                if (!type.isPrimitive()) break block10;
                switch (type.getClassIdentifier().charAt(0)) {
                    case 'I': {
                        this.addInstruction((AbstractInsnNode)new IntInsnNode(188, 10), comments);
                        break block11;
                    }
                    case 'Z': {
                        this.addInstruction((AbstractInsnNode)new IntInsnNode(188, 4), comments);
                        break block11;
                    }
                    case 'J': {
                        this.addInstruction((AbstractInsnNode)new IntInsnNode(188, 11), comments);
                        break block11;
                    }
                    case 'F': {
                        this.addInstruction((AbstractInsnNode)new IntInsnNode(188, 6), comments);
                        break block11;
                    }
                    case 'D': {
                        this.addInstruction((AbstractInsnNode)new IntInsnNode(188, 7), comments);
                        break block11;
                    }
                    case 'C': {
                        this.addInstruction((AbstractInsnNode)new IntInsnNode(188, 5), comments);
                        break block11;
                    }
                    case 'B': {
                        this.addInstruction((AbstractInsnNode)new IntInsnNode(188, 8), comments);
                        break block11;
                    }
                    case 'S': {
                        this.addInstruction((AbstractInsnNode)new IntInsnNode(188, 9), comments);
                        break block11;
                    }
                    default: {
                        throw new RuntimeException("Unsupported " + type);
                    }
                }
            }
            this.addInstruction((AbstractInsnNode)new TypeInsnNode(189, type.getClassIdentifier()), comments);
        }
    }

    public class Then
    extends ByteCodeBuilder<Then> {
        private final LabelNode endIf;

        Then(LabelNode endIf) {
            this.endIf = endIf;
        }

        @Override
        Then self() {
            return this;
        }

        public void endIf() {
            MethodByteCodeContext.this.addLabel(this.endIf, "endIf");
        }
    }

    public class Else
    extends ByteCodeBuilder<Else> {
        private LabelNode thenCase;
        private LabelNode endIf;

        Else(int jumpInst, Object ... comment) {
            this.thenCase = new LabelNode();
            this.endIf = new LabelNode();
            MethodByteCodeContext.this.addInstruction((AbstractInsnNode)new JumpInsnNode(jumpInst, this.thenCase), comment);
        }

        @Override
        Else self() {
            return this;
        }

        public Then thenCase() {
            MethodByteCodeContext.this.addInstruction((AbstractInsnNode)new JumpInsnNode(167, this.endIf), "end else, skip then");
            MethodByteCodeContext.this.addLabel(this.thenCase, "then label");
            return new Then(this.endIf);
        }
    }

    public abstract class ByteCodeBuilder<T> {
        abstract T self();

        public T addBool(boolean b, Object ... comment) {
            MethodByteCodeContext.this.addBool(b, comment);
            return this.self();
        }

        public T addIConst0(Object ... comment) {
            MethodByteCodeContext.this.addIConst0(comment);
            return this.self();
        }

        public T addIConst1(Object ... comment) {
            MethodByteCodeContext.this.addIConst1(comment);
            return this.self();
        }
    }
}

