/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.ClassBuilder;
import brennus.MethodContext;
import brennus.model.ExistingType;
import brennus.model.Type;

public final class Builder {
    private final boolean generateLineNumbers;

    int getSourceLineNumber() {
        if (this.generateLineNumbers) {
            StackTraceElement creatingStackFrame = this.getCreatingStackFrame();
            return creatingStackFrame != null && creatingStackFrame.getLineNumber() > 0 ? creatingStackFrame.getLineNumber() : 0;
        }
        return 0;
    }

    StackTraceElement getCreatingStackFrame() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String builderPackageName = MethodContext.class.getPackage().getName();
        for (StackTraceElement stackTraceElement : stackTrace) {
            String className = stackTraceElement.getClassName();
            String packageName = className.substring(0, className.lastIndexOf("."));
            if (packageName.startsWith("java.") || packageName.equals(builderPackageName)) continue;
            return stackTraceElement;
        }
        return null;
    }

    public Builder() {
        this(true);
    }

    public Builder(boolean generateLineNumbers) {
        this.generateLineNumbers = generateLineNumbers;
    }

    public ClassBuilder startClass(String name, Type extending) {
        return new ClassBuilder(name, extending, this);
    }

    public ClassBuilder startClass(String name) {
        return new ClassBuilder(name, ExistingType.OBJECT, this);
    }
}

