/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.Builder;
import brennus.Function;
import brennus.ImmutableList;
import brennus.StatementBuilder;
import brennus.SwitchBuilder;
import brennus.model.CaseBlockStatement;
import brennus.model.LiteralExpression;
import brennus.model.Statement;

public final class CaseBuilder<T>
extends StatementBuilder<CaseBuilder<T>> {
    private final LiteralExpression literalExpression;
    private final CaseStatementHandler<T> statementHandler;
    private final ImmutableList<Statement> statements;
    private final int line;

    CaseBuilder(LiteralExpression literalExpression, CaseStatementHandler<T> statementHandler, Builder builder) {
        this(literalExpression, statementHandler, builder, ImmutableList.empty(), builder.getSourceLineNumber());
    }

    private CaseBuilder(LiteralExpression literalExpression, CaseStatementHandler<T> statementHandler, Builder builder, ImmutableList<Statement> statements, int line) {
        super(builder);
        this.literalExpression = literalExpression;
        this.statementHandler = statementHandler;
        this.statements = statements;
        this.line = line;
    }

    private CaseBuilder<T> addStatement(Statement statement) {
        return new CaseBuilder<T>(this.literalExpression, this.statementHandler, this.builder, this.statements.append(statement), this.line);
    }

    public SwitchBuilder<T> endCase() {
        return this.statementHandler.handleStatement(new CaseBlockStatement(this.line, this.literalExpression, this.statements, false));
    }

    @Override
    protected StatementBuilder.StatementHandler<CaseBuilder<T>> statementHandler() {
        return new StatementBuilder.StatementHandler<CaseBuilder<T>>(){

            @Override
            public CaseBuilder<T> handleStatement(Statement statement) {
                return CaseBuilder.this.addStatement(statement);
            }
        };
    }

    public SwitchBuilder<T> breakCase() {
        return this.statementHandler.handleStatement(new CaseBlockStatement(this.line, this.literalExpression, this.statements, true));
    }

    public <S> S map(Function<CaseBuilder<T>, S> function) {
        return function.apply(this);
    }

    public static interface CaseStatementHandler<T> {
        public SwitchBuilder<T> handleStatement(CaseBlockStatement var1);
    }
}

