/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.Builder;
import brennus.ClassValidator;
import brennus.ConstructorDeclarationBuilder;
import brennus.ImmutableList;
import brennus.MethodBuilder;
import brennus.MethodDeclarationBuilder;
import brennus.model.ExistingType;
import brennus.model.Field;
import brennus.model.FutureType;
import brennus.model.MemberFlags;
import brennus.model.Method;
import brennus.model.Protection;
import brennus.model.Type;

public final class ClassBuilder {
    private final String name;
    private final Type extending;
    private final ImmutableList<Field> fields;
    private final ImmutableList<Field> staticFields;
    private final ImmutableList<Method> methods;
    private final ImmutableList<Method> staticMethods;
    private final ImmutableList<Method> constructors;
    private final String sourceFile;
    private final Builder builder;

    ClassBuilder(String name, Type extending, Builder builder) {
        this(name, extending, ImmutableList.empty(), ImmutableList.empty(), ImmutableList.empty(), ImmutableList.empty(), ImmutableList.empty(), ClassBuilder.getSourceFile(builder.getCreatingStackFrame()), builder);
    }

    private static String getSourceFile(StackTraceElement creatingStackFrame) {
        if (creatingStackFrame == null) {
            return "generated";
        }
        return creatingStackFrame.getFileName();
    }

    private ClassBuilder(String name, Type extending, ImmutableList<Field> fields, ImmutableList<Field> staticFields, ImmutableList<Method> methods, ImmutableList<Method> staticMethods, ImmutableList<Method> constructors, String sourceFile, Builder builder) {
        this.name = name;
        this.extending = extending;
        this.fields = fields;
        this.staticFields = staticFields;
        this.methods = methods;
        this.staticMethods = staticMethods;
        this.constructors = constructors;
        this.sourceFile = sourceFile;
        this.builder = builder;
    }

    public ClassBuilder field(Protection protection, Type type, String name) {
        return this.addField(protection, type, name, false);
    }

    public ClassBuilder staticField(Protection protection, Type type, String name) {
        return this.addField(protection, type, name, true);
    }

    public MethodDeclarationBuilder startStaticMethod(Protection protection, Type returnType, String methodName) {
        return this.startMethod(protection, returnType, methodName, true);
    }

    public MethodDeclarationBuilder startMethod(Protection protection, Type returnType, String methodName) {
        return this.startMethod(protection, returnType, methodName, false);
    }

    public FutureType endClass() {
        FutureType futureType = new FutureType(this.name, this.extending == null ? ExistingType.OBJECT : this.extending, this.fields, this.staticFields, this.methods, this.staticMethods, this.constructors, this.sourceFile);
        new ClassValidator().validate(futureType);
        return futureType;
    }

    public ConstructorDeclarationBuilder startConstructor(Protection protection) {
        return new ConstructorDeclarationBuilder(this.name.replace(".", "/"), protection, new MethodBuilder.MethodHandler(){

            @Override
            public ClassBuilder handleMethod(Method method) {
                return ClassBuilder.this.addConstructor(method);
            }
        }, this.builder);
    }

    private MethodDeclarationBuilder startMethod(Protection protection, Type returnType, String methodName, final boolean isStatic) {
        return new MethodDeclarationBuilder(this.name.replace(".", "/"), new MemberFlags(isStatic, false, protection), returnType, methodName, new MethodBuilder.MethodHandler(){

            @Override
            public ClassBuilder handleMethod(Method method) {
                return ClassBuilder.this.addMethod(isStatic, method);
            }
        }, this.builder);
    }

    private ClassBuilder newClassBuilder(ImmutableList<Field> newFields, ImmutableList<Field> newStaticFields, ImmutableList<Method> newMethods, ImmutableList<Method> newStaticMethods, ImmutableList<Method> newConstructors) {
        return new ClassBuilder(this.name, this.extending, newFields, newStaticFields, newMethods, newStaticMethods, newConstructors, this.sourceFile, this.builder);
    }

    private ClassBuilder addField(Protection protection, Type type, String name, boolean isStatic) {
        ImmutableList<Field> newFields = this.fields;
        ImmutableList<Field> newStaticFields = this.staticFields;
        Field newField = new Field(new MemberFlags(isStatic, false, protection), type, name);
        if (isStatic) {
            newStaticFields = newStaticFields.append(newField);
        } else {
            newFields = newFields.append(newField);
        }
        return this.newClassBuilder(newFields, newStaticFields, this.methods, this.staticMethods, this.constructors);
    }

    private ClassBuilder addConstructor(Method constructor) {
        return this.newClassBuilder(this.fields, this.staticFields, this.methods, this.staticMethods, this.constructors.append(constructor));
    }

    private ClassBuilder addMethod(boolean isStatic, Method method) {
        ImmutableList<Method> newMethods = this.methods;
        ImmutableList<Method> newStaticMethods = this.staticMethods;
        if (isStatic) {
            newStaticMethods = newStaticMethods.append(method);
        } else {
            newMethods = newMethods.append(method);
        }
        return this.newClassBuilder(this.fields, this.staticFields, newMethods, newStaticMethods, this.constructors);
    }
}

