/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.ImmutableList;
import brennus.MethodContext;
import brennus.model.CallConstructorStatement;
import brennus.model.CaseBlockStatement;
import brennus.model.DefineVarStatement;
import brennus.model.ExpressionStatement;
import brennus.model.FutureType;
import brennus.model.GotoCaseStatement;
import brennus.model.GotoStatement;
import brennus.model.IfStatement;
import brennus.model.LabelStatement;
import brennus.model.Method;
import brennus.model.ReturnStatement;
import brennus.model.SetStatement;
import brennus.model.Statement;
import brennus.model.StatementVisitor;
import brennus.model.SwitchStatement;
import brennus.model.ThrowStatement;

public class ClassValidator {
    public void validate(FutureType type) {
        for (Method method : type.getMethods()) {
            this.validate(type, method);
        }
        for (Method method : type.getStaticMethods()) {
            this.validate(type, method);
        }
    }

    private void validate(FutureType type, Method method) {
        MethodContext context = new MethodContext(type, method);
        ImmutableList<Statement> statements = method.getStatements();
        for (Statement statement : statements) {
            this.validate(context, statement);
        }
    }

    private void validate(MethodContext context, Statement statement) {
        try {
            StatementVisitor statementVisitor = new StatementVisitor(){

                @Override
                public void visit(SetStatement setStatement) {
                }

                @Override
                public void visit(ThrowStatement throwStatement) {
                }

                @Override
                public void visit(CaseBlockStatement caseStatement) {
                }

                @Override
                public void visit(SwitchStatement switchStatement) {
                }

                @Override
                public void visit(ExpressionStatement methodCallStatement) {
                }

                @Override
                public void visit(ReturnStatement returnStatement) {
                }

                @Override
                public void visit(IfStatement ifStatement) {
                }

                @Override
                public void visit(LabelStatement labelStatement) {
                }

                @Override
                public void visit(GotoStatement gotoStatement) {
                }

                @Override
                public void visit(CallConstructorStatement callConstructorStatement) {
                }

                @Override
                public void visit(DefineVarStatement defineVarStatement) {
                }

                @Override
                public void visit(GotoCaseStatement gotoCaseStatement) {
                }
            };
            statement.accept(statementVisitor);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("error at line " + statement.getLine() + " of method " + context.getClassIdentifier() + "." + context.getMethod().getName() + context.getMethod().getSignature(), e);
        }
    }
}

