/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.Builder;
import brennus.ClassBuilder;
import brennus.ImmutableList;
import brennus.MethodBuilder;
import brennus.StatementBuilder;
import brennus.model.ExistingType;
import brennus.model.MemberFlags;
import brennus.model.Method;
import brennus.model.Parameter;
import brennus.model.Protection;
import brennus.model.Statement;

public final class ConstructorBuilder
extends StatementBuilder<ConstructorBuilder> {
    private final String classIdentifier;
    private final Protection protection;
    private final ImmutableList<Parameter> parameters;
    private final MethodBuilder.MethodHandler methodHandler;
    private final ImmutableList<Statement> statements;

    ConstructorBuilder(String classIdentifier, Protection protection, ImmutableList<Parameter> parameters, MethodBuilder.MethodHandler methodHandler, Builder builder) {
        this(builder, classIdentifier, protection, parameters, methodHandler, ImmutableList.empty());
    }

    private ConstructorBuilder(Builder builder, String classIdentifier, Protection protection, ImmutableList<Parameter> parameters, MethodBuilder.MethodHandler methodHandler, ImmutableList<Statement> statements) {
        super(builder);
        this.classIdentifier = classIdentifier;
        this.protection = protection;
        this.parameters = parameters;
        this.methodHandler = methodHandler;
        this.statements = statements;
    }

    public ClassBuilder endConstructor() {
        return this.methodHandler.handleMethod(new Method(this.classIdentifier, new MemberFlags(false, false, this.protection), ExistingType.VOID, "<init>", this.parameters, this.statements, false));
    }

    @Override
    protected StatementBuilder.StatementHandler<ConstructorBuilder> statementHandler() {
        return new StatementBuilder.StatementHandler<ConstructorBuilder>(){

            @Override
            public ConstructorBuilder handleStatement(Statement statement) {
                return new ConstructorBuilder(ConstructorBuilder.this.builder, ConstructorBuilder.this.classIdentifier, ConstructorBuilder.this.protection, ConstructorBuilder.this.parameters, ConstructorBuilder.this.methodHandler, ConstructorBuilder.this.statements.append(statement));
            }
        };
    }
}

