/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.Builder;
import brennus.ConstructorBuilder;
import brennus.ConstructorCallBuilder;
import brennus.ConstructorCallExpressionBuilderFactory;
import brennus.ConstructorParamExpressionBuilder;
import brennus.ExpressionBuilder;
import brennus.ImmutableList;
import brennus.MethodBuilder;
import brennus.model.CallConstructorStatement;
import brennus.model.Expression;
import brennus.model.Parameter;
import brennus.model.Protection;
import brennus.model.Type;

public final class ConstructorDeclarationBuilder {
    private final String classIdentifier;
    private final Protection protection;
    private final ImmutableList<Parameter> parameters;
    private final MethodBuilder.MethodHandler methodHandler;
    private final Builder builder;

    ConstructorDeclarationBuilder(String classIdentifier, Protection protection, MethodBuilder.MethodHandler methodHandler, Builder builder) {
        this(classIdentifier, protection, ImmutableList.empty(), methodHandler, builder);
    }

    private ConstructorDeclarationBuilder(String classIdentifier, Protection protection, ImmutableList<Parameter> parameters, MethodBuilder.MethodHandler methodHandler, Builder builder) {
        this.classIdentifier = classIdentifier;
        this.protection = protection;
        this.parameters = parameters;
        this.methodHandler = methodHandler;
        this.builder = builder;
    }

    public ConstructorDeclarationBuilder param(Type type, String name) {
        return new ConstructorDeclarationBuilder(this.classIdentifier, this.protection, this.parameters.append(new Parameter(type, name, this.parameters.size())), this.methodHandler, this.builder);
    }

    private ConstructorCallBuilder innerContructorCall() {
        final int sourceLineNumber = this.builder.getSourceLineNumber();
        return new ConstructorCallBuilder(new ConstructorCallExpressionBuilderFactory(), new ExpressionBuilder.ExpressionHandler<ConstructorBuilder>(){

            @Override
            public ConstructorBuilder handleExpression(Expression e) {
                CallConstructorStatement callConstructorStatement = new CallConstructorStatement(sourceLineNumber, e);
                return new ConstructorBuilder(ConstructorDeclarationBuilder.this.classIdentifier, ConstructorDeclarationBuilder.this.protection, ConstructorDeclarationBuilder.this.parameters, ConstructorDeclarationBuilder.this.methodHandler, ConstructorDeclarationBuilder.this.builder).statementHandler().handleStatement(callConstructorStatement);
            }
        });
    }

    public ConstructorParamExpressionBuilder callSuperConstructor() {
        return this.innerContructorCall().param();
    }

    public ConstructorBuilder callSuperConstructorNoParam() {
        return this.innerContructorCall().endConstructorCall();
    }
}

