/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.Builder;
import brennus.Function;
import brennus.ImmutableList;
import brennus.StatementBuilder;
import brennus.ThenBuilder;
import brennus.model.Expression;
import brennus.model.IfStatement;
import brennus.model.Statement;

public final class ElseBuilder<T>
extends StatementBuilder<ElseBuilder<T>> {
    private final Expression ifExpression;
    private final int sourceLineNumber;
    private final ThenBuilder.IfStatementHandler<T> ifStatementHandler;
    private final ImmutableList<Statement> thenStatements;
    private final ImmutableList<Statement> elseStatements;

    ElseBuilder(Expression ifExpression, int sourceLineNumber, ThenBuilder.IfStatementHandler<T> ifStatementHandler, ImmutableList<Statement> thenStatements, Builder builder) {
        this(builder, ifExpression, sourceLineNumber, ifStatementHandler, thenStatements, ImmutableList.empty());
    }

    private ElseBuilder(Builder builder, Expression ifExpression, int sourceLineNumber, ThenBuilder.IfStatementHandler<T> ifStatementHandler, ImmutableList<Statement> thenStatements, ImmutableList<Statement> elseStatements) {
        super(builder);
        this.ifExpression = ifExpression;
        this.sourceLineNumber = sourceLineNumber;
        this.ifStatementHandler = ifStatementHandler;
        this.thenStatements = thenStatements;
        this.elseStatements = elseStatements;
    }

    @Override
    protected StatementBuilder.StatementHandler<ElseBuilder<T>> statementHandler() {
        return new StatementBuilder.StatementHandler<ElseBuilder<T>>(){

            @Override
            public ElseBuilder<T> handleStatement(Statement statement) {
                return new ElseBuilder(ElseBuilder.this.builder, ElseBuilder.this.ifExpression, ElseBuilder.this.sourceLineNumber, ElseBuilder.this.ifStatementHandler, ElseBuilder.this.thenStatements, ElseBuilder.this.elseStatements.append(statement));
            }
        };
    }

    public T endIf() {
        return this.ifStatementHandler.handleStatement(new IfStatement(this.ifExpression, this.sourceLineNumber, this.thenStatements, this.elseStatements));
    }

    public <S> S map(Function<ElseBuilder<T>, S> function) {
        return function.apply(this);
    }
}

