/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.ExpressionBuilderFactory;
import brennus.Function;
import brennus.ImmutableList;
import brennus.MethodCallBuilder;
import brennus.NewArrayExpressionBuilder;
import brennus.ParamExpressionBuilder;
import brennus.ValueExpressionBuilder;
import brennus.model.Expression;
import brennus.model.GetExpression;
import brennus.model.InstantiationExpression;
import brennus.model.LiteralExpression;
import brennus.model.NewArrayExpression;
import brennus.model.Type;
import brennus.model.UnaryExpression;
import brennus.model.UnaryOperator;

public abstract class ExpressionBuilder<T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> {
    private final ExpressionBuilderFactory<T, EB, VEB> factory;
    private final ExpressionHandler<T> expressionHandler;

    ExpressionBuilder(ExpressionBuilderFactory<T, EB, VEB> factory, ExpressionHandler<T> expressionHandler) {
        this.factory = factory;
        this.expressionHandler = expressionHandler;
    }

    private VEB newValueExpressionBuilder(ExpressionHandler<T> expressionHandler, Expression expression) {
        return (VEB)((ValueExpressionBuilder)this.factory.newValueExpressionBuilder(expressionHandler, expression));
    }

    private EB newExpressionBuilder(ExpressionHandler<T> expressionHandler) {
        return this.factory.newExpressionBuilder(expressionHandler);
    }

    private MethodCallBuilder<T, EB, VEB> innerCall(String methodName) {
        return new MethodCallBuilder<T, EB, VEB>(this.factory, null, methodName, this.expressionHandler);
    }

    private EB unaryOperator(final UnaryOperator operator) {
        return this.newExpressionBuilder(new ExpressionHandler<T>(){

            @Override
            public T handleExpression(Expression e) {
                return ExpressionBuilder.this.expressionHandler.handleExpression(new UnaryExpression(operator, e));
            }
        });
    }

    public VEB get(String name) {
        return this.newValueExpressionBuilder(this.expressionHandler, new GetExpression(name));
    }

    public ParamExpressionBuilder<T, EB, VEB> callOnThis(String methodName) {
        return this.innerCall(methodName).param();
    }

    public VEB callOnThisNoParam(String methodName) {
        return (VEB)((ValueExpressionBuilder)this.innerCall(methodName).endCall());
    }

    public VEB literal(int i) {
        return this.newValueExpressionBuilder(this.expressionHandler, new LiteralExpression(i));
    }

    public VEB literal(long l) {
        return this.newValueExpressionBuilder(this.expressionHandler, new LiteralExpression(l));
    }

    public VEB literal(float f) {
        return this.newValueExpressionBuilder(this.expressionHandler, new LiteralExpression(f));
    }

    public VEB literal(double d) {
        return this.newValueExpressionBuilder(this.expressionHandler, new LiteralExpression(d));
    }

    public VEB literal(String string) {
        return this.newValueExpressionBuilder(this.expressionHandler, new LiteralExpression(string));
    }

    public VEB literal(boolean b) {
        return this.newValueExpressionBuilder(this.expressionHandler, new LiteralExpression(b));
    }

    public EB not() {
        return this.unaryOperator(UnaryOperator.NOT);
    }

    public <R> R map(Function<EB, R> function) {
        return function.apply(this);
    }

    public VEB newInstanceNoParam(Type type) {
        return this.newValueExpressionBuilder(this.expressionHandler, new InstantiationExpression(type, ImmutableList.<Expression>empty()));
    }

    public NewArrayExpressionBuilder<VEB> newArrayOfSize(final Type type) {
        return new NewArrayExpressionBuilder(new ExpressionHandler<VEB>(){

            @Override
            public VEB handleExpression(Expression e) {
                return (ValueExpressionBuilder)ExpressionBuilder.this.factory.newValueExpressionBuilder(ExpressionBuilder.this.expressionHandler, new NewArrayExpression(type, e));
            }
        });
    }

    static interface ExpressionHandler<T> {
        public T handleExpression(Expression var1);
    }
}

