/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class ImmutableList<T>
implements Iterable<T> {
    private final List<T> content;

    public static final <U> ImmutableList<U> empty() {
        return new ImmutableList();
    }

    public static final <U> ImmutableList<U> from(Collection<U> content) {
        return new ImmutableList<U>(new ArrayList<U>(content));
    }

    private ImmutableList() {
        this.content = Collections.emptyList();
    }

    private ImmutableList(List<T> content) {
        this.content = Collections.unmodifiableList(content);
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    public ImmutableList<T> append(T o) {
        ArrayList<T> newContent = new ArrayList<T>(this.content);
        newContent.add(o);
        return new ImmutableList<T>(newContent);
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public int size() {
        return this.content.size();
    }

    public T get(int i) {
        return this.content.get(i);
    }

    public String toString() {
        return this.content.toString();
    }
}

