/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.Builder;
import brennus.ClassBuilder;
import brennus.Function;
import brennus.ImmutableList;
import brennus.StatementBuilder;
import brennus.model.MemberFlags;
import brennus.model.Method;
import brennus.model.Parameter;
import brennus.model.Statement;
import brennus.model.Type;

public final class MethodBuilder
extends StatementBuilder<MethodBuilder> {
    private final String classIdentifier;
    private final MemberFlags memberFlags;
    private final Type returnType;
    private final String name;
    private final ImmutableList<Parameter> parameters;
    private final MethodHandler methodHandler;
    private final ImmutableList<Statement> statements;

    MethodBuilder(String classIdentifier, MemberFlags memberFlags, Type returnType, String name, ImmutableList<Parameter> parameters, MethodHandler methodHandler, Builder builder) {
        this(builder, classIdentifier, memberFlags, returnType, name, parameters, methodHandler, ImmutableList.empty());
    }

    private MethodBuilder(Builder builder, String classIdentifier, MemberFlags memberFlags, Type returnType, String name, ImmutableList<Parameter> parameters, MethodHandler methodHandler, ImmutableList<Statement> statements) {
        super(builder);
        this.classIdentifier = classIdentifier;
        this.memberFlags = memberFlags;
        this.returnType = returnType;
        this.name = name;
        this.parameters = parameters;
        this.methodHandler = methodHandler;
        this.statements = statements;
    }

    public ClassBuilder endMethod() {
        return this.methodHandler.handleMethod(new Method(this.classIdentifier, this.memberFlags, this.returnType, this.name, this.parameters, this.statements, false));
    }

    @Override
    protected StatementBuilder.StatementHandler<MethodBuilder> statementHandler() {
        return new StatementBuilder.StatementHandler<MethodBuilder>(){

            @Override
            public MethodBuilder handleStatement(Statement statement) {
                return new MethodBuilder(MethodBuilder.this.builder, MethodBuilder.this.classIdentifier, MethodBuilder.this.memberFlags, MethodBuilder.this.returnType, MethodBuilder.this.name, MethodBuilder.this.parameters, MethodBuilder.this.methodHandler, MethodBuilder.this.statements.append(statement));
            }
        };
    }

    public <S> S map(Function<MethodBuilder, S> function) {
        return function.apply(this);
    }

    static interface MethodHandler {
        public ClassBuilder handleMethod(Method var1);
    }
}

