/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.ExpressionBuilder;
import brennus.ExpressionBuilderFactory;
import brennus.ImmutableList;
import brennus.ParamExpressionBuilder;
import brennus.model.CallMethodExpression;
import brennus.model.Expression;

public final class MethodCallBuilder<T, EB, VEB> {
    private final ExpressionBuilderFactory<T, EB, VEB> factory;
    private final Expression callee;
    private final String methodName;
    private final ExpressionBuilder.ExpressionHandler<T> expressionHandler;
    private final ImmutableList<Expression> parameters;

    MethodCallBuilder(ExpressionBuilderFactory<T, EB, VEB> factory, Expression callee, String methodName, ExpressionBuilder.ExpressionHandler<T> expressionHandler) {
        this(factory, callee, methodName, expressionHandler, ImmutableList.empty());
    }

    private MethodCallBuilder(ExpressionBuilderFactory<T, EB, VEB> factory, Expression callee, String methodName, ExpressionBuilder.ExpressionHandler<T> expressionHandler, ImmutableList<Expression> parameters) {
        this.factory = factory;
        this.callee = callee;
        this.methodName = methodName;
        this.expressionHandler = expressionHandler;
        this.parameters = parameters;
    }

    ParamExpressionBuilder<T, EB, VEB> param() {
        return new ParamExpressionBuilder(new ExpressionBuilder.ExpressionHandler<MethodCallBuilder<T, EB, VEB>>(){

            @Override
            public MethodCallBuilder<T, EB, VEB> handleExpression(Expression e) {
                return new MethodCallBuilder(MethodCallBuilder.this.factory, MethodCallBuilder.this.callee, MethodCallBuilder.this.methodName, MethodCallBuilder.this.expressionHandler, MethodCallBuilder.this.parameters.append(e));
            }
        });
    }

    VEB endCall() {
        return this.factory.newValueExpressionBuilder(this.expressionHandler, new CallMethodExpression(this.callee, this.methodName, this.parameters));
    }
}

