/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.ImmutableList;
import brennus.LocalVarContext;
import brennus.model.BoxingTypeConversion;
import brennus.model.CastTypeConversion;
import brennus.model.Field;
import brennus.model.FieldAccessType;
import brennus.model.FutureType;
import brennus.model.LocalVariableAccessType;
import brennus.model.Method;
import brennus.model.Parameter;
import brennus.model.ParameterAccessType;
import brennus.model.PrimitiveType;
import brennus.model.Type;
import brennus.model.TypeConversion;
import brennus.model.UnboxingTypeConversion;
import brennus.model.VarAccessType;
import java.util.HashMap;
import java.util.Map;

public final class MethodContext {
    private final FutureType type;
    private final Method method;
    private final Map<String, LocalVarContext> localVars = new HashMap<String, LocalVarContext>();

    public MethodContext(FutureType type, Method method) {
        this.type = type;
        this.method = method;
    }

    private Parameter getParam(String fieldName) {
        ImmutableList<Parameter> parameters = this.method.getParameters();
        for (Parameter parameter : parameters) {
            if (!parameter.getName().equals(fieldName)) continue;
            return parameter;
        }
        return null;
    }

    public VarAccessType getVarAccessType(String varName) {
        Parameter param = this.getParam(varName);
        if (param != null) {
            return new ParameterAccessType(param);
        }
        Field field = this.type.getField(varName);
        if (field != null) {
            return new FieldAccessType(field);
        }
        if (!this.localVars.containsKey(varName)) {
            throw new RuntimeException("can not access " + varName + " in parameters, local variables or fields");
        }
        LocalVarContext localVarContext = this.localVars.get(varName);
        return new LocalVariableAccessType(varName, localVarContext.getIndex(), localVarContext.getType());
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + this.method + "]";
    }

    public Type getReturnType() {
        return this.method.getReturnType();
    }

    public TypeConversion getTypeConversion(Type from, Type to) {
        if (to.equals(from)) {
            return TypeConversion.NONE;
        }
        if (from.isPrimitive() && !to.isPrimitive()) {
            return new BoxingTypeConversion((PrimitiveType)from);
        }
        if (!from.isPrimitive() && to.isPrimitive()) {
            return new UnboxingTypeConversion((PrimitiveType)to);
        }
        if (!from.isPrimitive() && !to.isPrimitive()) {
            if (to.isAssignableFrom(from)) {
                return TypeConversion.NONE;
            }
            return new CastTypeConversion(to);
        }
        throw new UnsupportedOperationException("TODO: convert " + from + " to " + to);
    }

    public Method getMethod() {
        return this.method;
    }

    public String getClassIdentifier() {
        return this.type.getClassIdentifier();
    }

    public FutureType getType() {
        return this.type;
    }

    public LocalVarContext defineLocalVar(Type type, String varName) {
        if (this.localVars.containsKey(varName)) {
            throw new RuntimeException("Duplicate local variable " + varName + " in method " + this.method.toString());
        }
        LocalVarContext context = new LocalVarContext(varName, this.localVars.size(), type);
        this.localVars.put(varName, context);
        return context;
    }
}

