/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.Builder;
import brennus.ExecExpressionBuilder;
import brennus.ExpressionBuilder;
import brennus.ReturnExpressionBuilder;
import brennus.SetExpressionBuilder;
import brennus.SwitchBuilder;
import brennus.SwitchExpressionBuilder;
import brennus.ThenBuilder;
import brennus.ThenExpressionBuilder;
import brennus.ThrowExpressionBuilder;
import brennus.model.DefineVarStatement;
import brennus.model.Expression;
import brennus.model.ExpressionStatement;
import brennus.model.GotoStatement;
import brennus.model.IfStatement;
import brennus.model.LabelStatement;
import brennus.model.ReturnStatement;
import brennus.model.SetStatement;
import brennus.model.Statement;
import brennus.model.SwitchStatement;
import brennus.model.ThrowStatement;
import brennus.model.Type;

public abstract class StatementBuilder<T> {
    protected final Builder builder;

    protected StatementBuilder(Builder builder) {
        this.builder = builder;
    }

    protected abstract StatementHandler<T> statementHandler();

    public final ReturnExpressionBuilder<T> returnExp() {
        final int sourceLineNumber = this.builder.getSourceLineNumber();
        return new ReturnExpressionBuilder(new ExpressionBuilder.ExpressionHandler<T>(){

            @Override
            public T handleExpression(Expression e) {
                return StatementBuilder.this.statementHandler().handleStatement(new ReturnStatement(sourceLineNumber, e));
            }
        });
    }

    public final SwitchExpressionBuilder<T> switchOn() {
        return new SwitchExpressionBuilder(new ExpressionBuilder.ExpressionHandler<SwitchBuilder<T>>(){

            @Override
            public SwitchBuilder<T> handleExpression(Expression e) {
                return new SwitchBuilder(e, new SwitchBuilder.SwitchStatementsHandler<T>(){

                    @Override
                    public T handleStatement(SwitchStatement switchStatement) {
                        return StatementBuilder.this.statementHandler().handleStatement(switchStatement);
                    }
                }, StatementBuilder.this.builder);
            }
        });
    }

    public final ThrowExpressionBuilder<T> throwExp() {
        final int sourceLineNumber = this.builder.getSourceLineNumber();
        return new ThrowExpressionBuilder(new ExpressionBuilder.ExpressionHandler<T>(){

            @Override
            public T handleExpression(Expression e) {
                return StatementBuilder.this.statementHandler().handleStatement(new ThrowStatement(sourceLineNumber, e));
            }
        });
    }

    public final SetExpressionBuilder<T> set(final String to) {
        final int sourceLineNumber = this.builder.getSourceLineNumber();
        return new SetExpressionBuilder(new ExpressionBuilder.ExpressionHandler<T>(){

            @Override
            public T handleExpression(Expression e) {
                return StatementBuilder.this.statementHandler().handleStatement(new SetStatement(sourceLineNumber, to, e));
            }
        });
    }

    public final ThenExpressionBuilder<T> ifExp() {
        return new ThenExpressionBuilder(new ExpressionBuilder.ExpressionHandler<ThenBuilder<T>>(){

            @Override
            public ThenBuilder<T> handleExpression(Expression e) {
                return new ThenBuilder(e, new ThenBuilder.IfStatementHandler<T>(){

                    @Override
                    public T handleStatement(IfStatement ifStatement) {
                        return StatementBuilder.this.statementHandler().handleStatement(ifStatement);
                    }
                }, StatementBuilder.this.builder);
            }
        });
    }

    public final ExecExpressionBuilder<T> exec() {
        final int sourceLineNumber = this.builder.getSourceLineNumber();
        return new ExecExpressionBuilder(new ExpressionBuilder.ExpressionHandler<T>(){

            @Override
            public T handleExpression(Expression e) {
                return StatementBuilder.this.statementHandler().handleStatement(new ExpressionStatement(sourceLineNumber, e));
            }
        });
    }

    public final T label(String labelName) {
        return this.statementHandler().handleStatement(new LabelStatement(this.builder.getSourceLineNumber(), labelName));
    }

    public T gotoLabel(String labelName) {
        return this.statementHandler().handleStatement(new GotoStatement(this.builder.getSourceLineNumber(), labelName));
    }

    public T var(Type type, String varName) {
        return this.statementHandler().handleStatement(new DefineVarStatement(this.builder.getSourceLineNumber(), type, varName));
    }

    static interface StatementHandler<T> {
        public T handleStatement(Statement var1);
    }
}

