/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.Builder;
import brennus.CaseBuilder;
import brennus.Function;
import brennus.ImmutableList;
import brennus.model.CaseBlockStatement;
import brennus.model.CaseStatement;
import brennus.model.Expression;
import brennus.model.GotoCaseStatement;
import brennus.model.LiteralExpression;
import brennus.model.SwitchStatement;

public final class SwitchBuilder<T> {
    private final Expression switchOnExpression;
    private final int line;
    private final SwitchStatementsHandler<T> switchStatementHandler;
    private final ImmutableList<CaseStatement> statements;
    private final CaseBlockStatement defaultCaseStatement;
    private final Builder builder;

    SwitchBuilder(Expression switchOnExpression, SwitchStatementsHandler<T> switchStatementHandler, Builder builder) {
        this(switchOnExpression, builder.getSourceLineNumber(), switchStatementHandler, ImmutableList.empty(), null, builder);
    }

    private SwitchBuilder(Expression switchOnExpression, int line, SwitchStatementsHandler<T> switchStatementHandler, ImmutableList<CaseStatement> statements, CaseBlockStatement defaultCaseStatement, Builder builder) {
        this.switchOnExpression = switchOnExpression;
        this.line = line;
        this.switchStatementHandler = switchStatementHandler;
        this.statements = statements;
        this.defaultCaseStatement = defaultCaseStatement;
        this.builder = builder;
    }

    private SwitchBuilder<T> newSwitchBuilder(ImmutableList<CaseStatement> newStatements, CaseBlockStatement newDefaultCaseStatement) {
        return new SwitchBuilder<T>(this.switchOnExpression, this.line, this.switchStatementHandler, newStatements, newDefaultCaseStatement, this.builder);
    }

    public CaseBuilder<T> caseBlock(int value) {
        return new CaseBuilder(new LiteralExpression(value), new CaseBuilder.CaseStatementHandler<T>(){

            @Override
            public SwitchBuilder<T> handleStatement(CaseBlockStatement statement) {
                return SwitchBuilder.this.newSwitchBuilder(SwitchBuilder.this.statements.append(statement), SwitchBuilder.this.defaultCaseStatement);
            }
        }, this.builder);
    }

    public SwitchBuilder<T> gotoLabel(int value, String label) {
        return this.newSwitchBuilder(this.statements.append(new GotoCaseStatement(this.builder.getSourceLineNumber(), value, label)), this.defaultCaseStatement);
    }

    public CaseBuilder<T> defaultCase() {
        if (this.defaultCaseStatement != null) {
            throw new RuntimeException("already a default case " + this.defaultCaseStatement);
        }
        return new CaseBuilder(null, new CaseBuilder.CaseStatementHandler<T>(){

            @Override
            public SwitchBuilder<T> handleStatement(CaseBlockStatement statement) {
                return SwitchBuilder.this.newSwitchBuilder(SwitchBuilder.this.statements, statement);
            }
        }, this.builder);
    }

    public T endSwitch() {
        return this.switchStatementHandler.handleStatement(new SwitchStatement(this.line, this.switchOnExpression, this.statements, this.defaultCaseStatement));
    }

    public <U> U map(Function<SwitchBuilder<T>, U> function) {
        return function.apply(this);
    }

    static interface SwitchStatementsHandler<T> {
        public T handleStatement(SwitchStatement var1);
    }
}

