/*
 * Decompiled with CFR 0.152.
 */
package brennus;

import brennus.ArrayIndexExpressionBuilder;
import brennus.ExpressionBuilder;
import brennus.ExpressionBuilderFactory;
import brennus.MethodCallBuilder;
import brennus.ParamExpressionBuilder;
import brennus.model.BinaryExpression;
import brennus.model.BinaryOperator;
import brennus.model.CastExpression;
import brennus.model.ExistingType;
import brennus.model.Expression;
import brennus.model.InstanceOfExpression;
import brennus.model.Type;
import brennus.model.UnaryExpression;
import brennus.model.UnaryOperator;

public abstract class ValueExpressionBuilder<T, EB, VEB> {
    private final ExpressionBuilderFactory<T, EB, VEB> factory;
    private final ExpressionBuilder.ExpressionHandler<T> expressionHandler;
    private final Expression expression;

    ValueExpressionBuilder(ExpressionBuilderFactory<T, EB, VEB> factory, ExpressionBuilder.ExpressionHandler<T> expressionHandler, Expression expression) {
        this.factory = factory;
        this.expressionHandler = expressionHandler;
        this.expression = expression;
    }

    public EB and() {
        return this.binaryOperator(BinaryOperator.AND);
    }

    public EB add() {
        return this.binaryOperator(BinaryOperator.PLUS);
    }

    public EB isEqualTo() {
        return this.binaryOperator(BinaryOperator.EQUALS);
    }

    public EB isGreaterThan() {
        return this.binaryOperator(BinaryOperator.GREATER_THAN);
    }

    public VEB isNull() {
        return this.newValueExpressionBuilder(this.expressionHandler, new UnaryExpression(UnaryOperator.ISNULL, this.expression));
    }

    public VEB isNotNull() {
        return this.newValueExpressionBuilder(this.expressionHandler, new UnaryExpression(UnaryOperator.ISNOTNULL, this.expression));
    }

    public VEB arraySize() {
        return this.newValueExpressionBuilder(this.expressionHandler, new UnaryExpression(UnaryOperator.ARRAYSIZE, this.expression));
    }

    public VEB instanceOf(ExistingType existingType) {
        return this.newValueExpressionBuilder(this.expressionHandler, new InstanceOfExpression(this.expression, existingType));
    }

    public VEB castTo(Type type) {
        return this.newValueExpressionBuilder(this.expressionHandler, new CastExpression(type, this.expression));
    }

    T end() {
        return this.expressionHandler.handleExpression(this.expression);
    }

    private EB newExpressionBuilder(ExpressionBuilder.ExpressionHandler<T> expressionHandler) {
        return this.factory.newExpressionBuilder(expressionHandler);
    }

    private VEB newValueExpressionBuilder(ExpressionBuilder.ExpressionHandler<T> expressionHandler, Expression expression) {
        return this.factory.newValueExpressionBuilder(expressionHandler, expression);
    }

    private EB binaryOperator(final BinaryOperator operator) {
        return this.newExpressionBuilder(new ExpressionBuilder.ExpressionHandler<T>(){

            @Override
            public T handleExpression(Expression e) {
                return ValueExpressionBuilder.this.expressionHandler.handleExpression(new BinaryExpression(ValueExpressionBuilder.this.expression, operator, e));
            }
        });
    }

    public ParamExpressionBuilder<T, EB, VEB> call(String methodName) {
        return new MethodCallBuilder<T, EB, VEB>(this.factory, this.expression, methodName, this.expressionHandler).param();
    }

    public VEB callNoParam(String methodName) {
        return new MethodCallBuilder<T, EB, VEB>(this.factory, this.expression, methodName, this.expressionHandler).endCall();
    }

    public ArrayIndexExpressionBuilder<VEB> getArrayValueAt() {
        return new ArrayIndexExpressionBuilder(new ExpressionBuilder.ExpressionHandler<VEB>(){

            @Override
            public VEB handleExpression(Expression e) {
                return ValueExpressionBuilder.this.factory.newValueExpressionBuilder(ValueExpressionBuilder.this.expressionHandler, new BinaryExpression(ValueExpressionBuilder.this.expression, BinaryOperator.GETARRAYATINDEX, e));
            }
        });
    }
}

