/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.model.BinaryOperator;
import brennus.model.ExceptionHandlingVisitor;
import brennus.model.Expression;
import brennus.model.ExpressionVisitor;

public final class BinaryExpression
extends Expression {
    private final Expression leftExpression;
    private final BinaryOperator operator;
    private final Expression rightExpression;

    public BinaryExpression(Expression leftExpression, BinaryOperator operator, Expression rightExpression) {
        this.leftExpression = leftExpression;
        this.operator = operator;
        this.rightExpression = rightExpression;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        ExceptionHandlingVisitor.wrap(expressionVisitor).visit(this);
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public BinaryOperator getOperator() {
        return this.operator;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public String toString() {
        return "[" + this.leftExpression + " " + this.getOperator().getRepresentation() + " " + this.rightExpression + "]";
    }
}

