/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.ImmutableList;
import brennus.model.ExceptionHandlingVisitor;
import brennus.model.Expression;
import brennus.model.ExpressionVisitor;

public final class CallMethodExpression
extends Expression {
    private final Expression callee;
    private final String methodName;
    private final ImmutableList<Expression> parameters;

    public CallMethodExpression(Expression callee, String methodName, ImmutableList<Expression> parameters) {
        this.callee = callee;
        this.methodName = methodName;
        this.parameters = parameters;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        ExceptionHandlingVisitor.wrap(expressionVisitor).visit(this);
    }

    public ImmutableList<Expression> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + (this.callee == null ? "this" : this.callee) + "." + this.methodName + "(" + this.parameters + ")]";
    }

    public Expression getCallee() {
        return this.callee;
    }
}

