/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.ImmutableList;
import brennus.model.CaseStatement;
import brennus.model.CaseStatementVisitor;
import brennus.model.ExceptionHandlingVisitor;
import brennus.model.LiteralExpression;
import brennus.model.Statement;
import brennus.model.StatementVisitor;

public final class CaseBlockStatement
extends CaseStatement {
    private final ImmutableList<Statement> statements;
    private final boolean breakCase;

    public CaseBlockStatement(int line, LiteralExpression value, ImmutableList<Statement> statements, boolean breakCase) {
        super(value, line);
        this.statements = statements;
        this.breakCase = breakCase;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        ExceptionHandlingVisitor.wrap(statementVisitor).visit(this);
    }

    public ImmutableList<Statement> getStatements() {
        return this.statements;
    }

    public boolean isBreakCase() {
        return this.breakCase;
    }

    public LiteralExpression getliteralExpression() {
        return (LiteralExpression)this.getExpression();
    }

    @Override
    public void accept(CaseStatementVisitor visitor) {
        ExceptionHandlingVisitor.wrap(visitor).visit(this);
    }
}

