/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.ImmutableList;
import brennus.model.ExceptionHandlingVisitor;
import brennus.model.Field;
import brennus.model.FutureType;
import brennus.model.MemberFlags;
import brennus.model.Method;
import brennus.model.Parameter;
import brennus.model.PrimitiveType;
import brennus.model.Statement;
import brennus.model.Type;
import brennus.model.TypeVisitor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ExistingType
extends Type {
    private static final Map<Class<?>, PrimitiveType> primitives = new HashMap();
    public static final PrimitiveType VOID = ExistingType.primitive(Void.TYPE, "V", Void.class);
    public static final PrimitiveType INT = ExistingType.primitive(Integer.TYPE, "I", Integer.class);
    public static final PrimitiveType LONG = ExistingType.primitive(Long.TYPE, "J", Long.class);
    public static final PrimitiveType BYTE = ExistingType.primitive(Byte.TYPE, "B", Byte.class);
    public static final PrimitiveType BOOLEAN = ExistingType.primitive(Boolean.TYPE, "Z", Boolean.class);
    public static final PrimitiveType SHORT = ExistingType.primitive(Short.TYPE, "S", Short.class);
    public static final PrimitiveType CHAR = ExistingType.primitive(Character.TYPE, "C", Character.class);
    public static final PrimitiveType FLOAT = ExistingType.primitive(Float.TYPE, "F", Float.class);
    public static final PrimitiveType DOUBLE = ExistingType.primitive(Double.TYPE, "D", Double.class);
    public static final ExistingType STRING = ExistingType.existing(String.class);
    public static final ExistingType OBJECT = ExistingType.existing(Object.class);
    private final Class<?> existing;
    private final String identifier;
    private final String signature;

    private static PrimitiveType primitive(Class<?> existingPrimitive, String identifier, Class<?> boxedType) {
        if (!existingPrimitive.isPrimitive()) {
            throw new RuntimeException("Not a primitive " + existingPrimitive);
        }
        PrimitiveType existingType = new PrimitiveType(existingPrimitive, identifier, identifier, ExistingType.existing(boxedType));
        primitives.put(existingPrimitive, existingType);
        return existingType;
    }

    public static ExistingType existing(Class<?> existing) {
        String signature;
        String identifier;
        if (existing.isPrimitive()) {
            ExistingType existingType = primitives.get(existing);
            if (existingType == null) {
                throw new RuntimeException("Unexpected primitive " + existing);
            }
            return existingType;
        }
        if (existing.isArray()) {
            ExistingType component = ExistingType.existing(existing.getComponentType());
            signature = identifier = "[" + component.getSignature();
        } else {
            identifier = existing.getName().replace(".", "/");
            signature = "L" + identifier + ";";
        }
        return new ExistingType(existing, identifier, signature);
    }

    ExistingType(Class<?> existing, String identifier, String signature) {
        this.existing = existing;
        this.identifier = identifier;
        this.signature = signature;
    }

    @Override
    public void accept(TypeVisitor typeVisitor) {
        ExceptionHandlingVisitor.wrap(typeVisitor).visit(this);
    }

    public Class<?> getExisting() {
        return this.existing;
    }

    @Override
    public String getName() {
        return this.existing.getName();
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    public Class<?> getExistingClass() {
        return this.existing;
    }

    @Override
    public String getClassIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isPrimitive() {
        return this.existing.isPrimitive();
    }

    @Override
    public Method getMethod(String methodName, int parameterCount) {
        java.lang.reflect.Method[] declaredMethods;
        for (java.lang.reflect.Method method : declaredMethods = this.existing.getDeclaredMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!method.getName().equals(methodName) || parameterTypes.length != parameterCount) continue;
            ImmutableList<Parameter> parameters = this.convertParameters(parameterTypes);
            return new Method(this.getClassIdentifier(), MemberFlags.fromReflection(method), ExistingType.existing(method.getReturnType()), methodName, parameters, ImmutableList.<Statement>empty(), this.existing.isInterface());
        }
        if (this.existing.getSuperclass() != null) {
            return ExistingType.existing(this.existing.getSuperclass()).getMethod(methodName, parameterCount);
        }
        return null;
    }

    @Override
    public Field getField(String name) {
        java.lang.reflect.Field field;
        try {
            field = this.existing.getField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        if (field != null) {
            return new Field(MemberFlags.fromReflection(field), ExistingType.existing(field.getType()), field.getName());
        }
        return null;
    }

    private ImmutableList<Parameter> convertParameters(Class<?>[] parameterTypes) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> paramClass = parameterTypes[i];
            parameters.add(new Parameter(ExistingType.existing(paramClass), "arg" + i, i));
        }
        return ImmutableList.from(parameters);
    }

    @Override
    public Method getConstructor(int parameterCount) {
        for (Constructor<?> constructor : this.existing.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != parameterCount) continue;
            ImmutableList<Parameter> parameters = this.convertParameters(parameterTypes);
            return new Method(this.getClassIdentifier(), MemberFlags.fromReflection(constructor), VOID, "<init>", parameters, ImmutableList.<Statement>empty(), false);
        }
        return null;
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        class TypeVisitorImplementation
        implements TypeVisitor {
            boolean isAssignableFrom;

            TypeVisitorImplementation() {
            }

            @Override
            public void visit(ExistingType other) {
                this.isAssignableFrom = ExistingType.this.existing.isAssignableFrom(other.existing);
            }

            @Override
            public void visit(FutureType futureType) {
                this.isAssignableFrom = ExistingType.this.isAssignableFrom(futureType.getExtending());
            }
        }
        TypeVisitorImplementation typeVisitor = new TypeVisitorImplementation();
        type.accept(typeVisitor);
        return typeVisitor.isAssignableFrom;
    }

    @Override
    public Type unNestArray() {
        if (this.existing.isArray()) {
            return ExistingType.existing(this.existing.getComponentType());
        }
        throw new RuntimeException("not an array type: " + this);
    }

    @Override
    public Type nestArray() {
        return ExistingType.existing(Array.newInstance(this.existing, 0).getClass());
    }
}

