/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.ImmutableList;
import brennus.model.ExceptionHandlingVisitor;
import brennus.model.ExistingType;
import brennus.model.Field;
import brennus.model.Method;
import brennus.model.Type;
import brennus.model.TypeVisitor;

public final class FutureType
extends Type {
    private final String name;
    private final Type extending;
    private final ImmutableList<Field> fields;
    private final ImmutableList<Field> staticFields;
    private final ImmutableList<Method> methods;
    private final ImmutableList<Method> staticMethods;
    private final String sourceFile;
    private final ImmutableList<Method> constructors;

    public FutureType(String name, Type extending, ImmutableList<Field> fields, ImmutableList<Field> staticFields, ImmutableList<Method> methods, ImmutableList<Method> staticMethods, ImmutableList<Method> constructors, String sourceFile) {
        this.name = name;
        this.extending = extending;
        this.fields = fields;
        this.staticFields = staticFields;
        this.methods = methods;
        this.staticMethods = staticMethods;
        this.constructors = constructors;
        this.sourceFile = sourceFile;
    }

    @Override
    public void accept(TypeVisitor typeVisitor) {
        ExceptionHandlingVisitor.wrap(typeVisitor).visit(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Type getExtending() {
        return this.extending;
    }

    public ImmutableList<Field> getFields() {
        return this.fields;
    }

    public ImmutableList<Field> getStaticFields() {
        return this.staticFields;
    }

    public ImmutableList<Method> getMethods() {
        return this.methods;
    }

    public ImmutableList<Method> getStaticMethods() {
        return this.staticMethods;
    }

    public ImmutableList<Method> getConstructors() {
        return this.constructors;
    }

    @Override
    public String getClassIdentifier() {
        return this.getName().replace('.', '/');
    }

    @Override
    public String getSignature() {
        return "L" + this.getClassIdentifier() + ";";
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Method getMethod(String methodName, int parameterCount) {
        for (Method method : this.methods) {
            if (!method.getName().equals(methodName) || method.getParameters().size() != parameterCount) continue;
            return method;
        }
        if (this.extending != null) {
            return this.extending.getMethod(methodName, parameterCount);
        }
        return null;
    }

    @Override
    public Field getField(String varName) {
        Field field = this.getField(this.getFields(), varName);
        if (field == null) {
            field = this.getField(this.getStaticFields(), varName);
        }
        if (field == null && this.extending != null) {
            field = this.extending.getField(varName);
        }
        return field;
    }

    private Field getField(ImmutableList<Field> fields, String varName) {
        for (Field field : fields) {
            if (!field.getName().equals(varName)) continue;
            return field;
        }
        return null;
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        System.out.println(this + ".isAssignableFrom." + type);
        class TypeVisitorImplementation
        implements TypeVisitor {
            boolean isAssignableFrom;

            TypeVisitorImplementation() {
            }

            @Override
            public void visit(ExistingType other) {
                this.isAssignableFrom = false;
            }

            @Override
            public void visit(FutureType futureType) {
                this.isAssignableFrom = FutureType.this.name.equals(futureType.name) || FutureType.this.isAssignableFrom(futureType.getExtending());
            }
        }
        TypeVisitorImplementation typeVisitor = new TypeVisitorImplementation();
        type.accept(typeVisitor);
        System.out.println(this + ".isAssignableFrom." + type + "=" + typeVisitor.isAssignableFrom);
        return typeVisitor.isAssignableFrom;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public Method getSuperConstructor(int parameterCount) {
        return this.getExtending().getConstructor(parameterCount);
    }

    @Override
    public Method getConstructor(int parameterCount) {
        for (Method constructor : this.constructors) {
            if (constructor.getParameters().size() != parameterCount) continue;
            return constructor;
        }
        if (this.extending != null) {
            return this.extending.getConstructor(parameterCount);
        }
        return null;
    }

    @Override
    public Type unNestArray() {
        throw new RuntimeException("not an array type: " + this);
    }

    @Override
    public Type nestArray() {
        throw new UnsupportedOperationException("NYI");
    }
}

