/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.ImmutableList;
import brennus.model.ExceptionHandlingVisitor;
import brennus.model.Expression;
import brennus.model.Statement;
import brennus.model.StatementVisitor;

public final class IfStatement
extends Statement {
    private final ImmutableList<Statement> thenStatements;
    private final ImmutableList<Statement> elseStatements;

    public IfStatement(Expression ifExpression, int line, ImmutableList<Statement> thenStatements, ImmutableList<Statement> elseStatements) {
        super(ifExpression, line);
        this.thenStatements = thenStatements;
        this.elseStatements = elseStatements;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        ExceptionHandlingVisitor.wrap(statementVisitor).visit(this);
    }

    public ImmutableList<Statement> getThenStatements() {
        return this.thenStatements;
    }

    public ImmutableList<Statement> getElseStatements() {
        return this.elseStatements;
    }
}

