/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.model.ExceptionHandlingVisitor;
import brennus.model.ExistingType;
import brennus.model.Expression;
import brennus.model.ExpressionVisitor;

public final class LiteralExpression
extends Expression {
    private final Object value;
    private final ExistingType type;

    public LiteralExpression(int value) {
        this.value = value;
        this.type = ExistingType.INT;
    }

    public LiteralExpression(long value) {
        this.value = value;
        this.type = ExistingType.LONG;
    }

    public LiteralExpression(float value) {
        this.value = Float.valueOf(value);
        this.type = ExistingType.FLOAT;
    }

    public LiteralExpression(double value) {
        this.value = value;
        this.type = ExistingType.DOUBLE;
    }

    public LiteralExpression(String value) {
        this.value = value;
        this.type = ExistingType.STRING;
    }

    public LiteralExpression(boolean value) {
        this.value = value;
        this.type = ExistingType.BOOLEAN;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        ExceptionHandlingVisitor.wrap(expressionVisitor).visit(this);
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + this.value + "]";
    }

    public ExistingType getType() {
        return this.type;
    }
}

