/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.model.FinalStatus;
import brennus.model.Keyword;
import brennus.model.Protection;
import brennus.model.StaticStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class MemberFlags {
    private final Keyword[] keywords;
    private final boolean isStatic;
    private final boolean isFinal;
    private final Protection protection;

    public MemberFlags(Keyword[] keywords) {
        this.keywords = keywords;
        this.protection = Protection.getProtection(keywords);
        this.isStatic = StaticStatus.isStatic(keywords);
        this.isFinal = FinalStatus.isFinal(keywords);
    }

    public MemberFlags(boolean isStatic, boolean isFinal, Protection protection) {
        Keyword[] keywordArray;
        if (isStatic) {
            Keyword[] keywordArray2 = new Keyword[2];
            keywordArray2[0] = StaticStatus.STATIC;
            keywordArray = keywordArray2;
            keywordArray2[1] = protection;
        } else {
            Keyword[] keywordArray3 = new Keyword[1];
            keywordArray = keywordArray3;
            keywordArray3[0] = protection;
        }
        this.keywords = keywordArray;
        this.protection = protection;
        this.isStatic = isStatic;
        this.isFinal = isFinal;
    }

    public Protection getProtection() {
        return this.protection;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    Keyword[] getKeywords() {
        return this.keywords;
    }

    public static MemberFlags fromKeywords(Keyword ... keywords) {
        return new MemberFlags(keywords);
    }

    public static MemberFlags fromReflection(Method method) {
        return MemberFlags.fromModifiers(method.getModifiers());
    }

    public static MemberFlags fromReflection(Constructor<?> constructor) {
        Protection protection = MemberFlags.getProtection(constructor.getModifiers());
        return new MemberFlags(false, false, protection);
    }

    public static MemberFlags fromReflection(Field field) {
        return MemberFlags.fromModifiers(field.getModifiers());
    }

    private static MemberFlags fromModifiers(int modifiers) {
        Protection protection = MemberFlags.getProtection(modifiers);
        return new MemberFlags(Modifier.isStatic(modifiers), Modifier.isFinal(modifiers), protection);
    }

    private static Protection getProtection(int modifiers) {
        Protection protection = Modifier.isPublic(modifiers) ? Protection.PUBLIC : (Modifier.isPrivate(modifiers) ? Protection.PRIVATE : (Modifier.isProtected(modifiers) ? Protection.PROTECTED : Protection.DEFAULT));
        return protection;
    }

    public boolean isFinal() {
        return this.isFinal;
    }
}

