/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.ImmutableList;
import brennus.model.MemberFlags;
import brennus.model.Parameter;
import brennus.model.Statement;
import brennus.model.Type;

public final class Method {
    private final String typeName;
    private final MemberFlags memberFlags;
    private final Type returnType;
    private final String name;
    private final ImmutableList<Parameter> parameters;
    private final ImmutableList<Statement> statements;
    private final boolean interfaceMethod;

    public Method(String typeName, MemberFlags memberFlags, Type returnType, String name, ImmutableList<Parameter> parameters, ImmutableList<Statement> statements, boolean interfaceMethod) {
        this.typeName = typeName;
        this.memberFlags = memberFlags;
        this.returnType = returnType;
        this.name = name;
        this.parameters = parameters;
        this.statements = statements;
        this.interfaceMethod = interfaceMethod;
    }

    public String getName() {
        return this.name;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public ImmutableList<Statement> getStatements() {
        return this.statements;
    }

    public boolean isStatic() {
        return this.memberFlags.isStatic();
    }

    public MemberFlags getFlags() {
        return this.memberFlags;
    }

    public ImmutableList<Parameter> getParameters() {
        return this.parameters;
    }

    public String getSignature() {
        StringBuilder signature = new StringBuilder("(");
        for (Parameter parameter : this.parameters) {
            signature.append(parameter.getType().getSignature());
        }
        signature.append(")");
        signature.append(this.returnType.getSignature());
        return signature.toString();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isInterfaceMethod() {
        return this.interfaceMethod;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + this.name + this.getSignature() + "]";
    }
}

