/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.ImmutableList;
import brennus.model.CaseBlockStatement;
import brennus.model.CaseStatement;
import brennus.model.ExceptionHandlingVisitor;
import brennus.model.Expression;
import brennus.model.Statement;
import brennus.model.StatementVisitor;

public final class SwitchStatement
extends Statement {
    private final ImmutableList<CaseStatement> caseStatements;
    private final CaseBlockStatement defaultCaseStatement;

    public SwitchStatement(int line, Expression expression, ImmutableList<CaseStatement> caseStatements, CaseBlockStatement defaultCaseStatement) {
        super(expression, line);
        this.caseStatements = caseStatements;
        this.defaultCaseStatement = defaultCaseStatement;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        ExceptionHandlingVisitor.wrap(statementVisitor).visit(this);
    }

    public ImmutableList<CaseStatement> getCaseStatements() {
        return this.caseStatements;
    }

    public CaseBlockStatement getDefaultCaseStatement() {
        return this.defaultCaseStatement;
    }
}

