/*
 * Decompiled with CFR 0.152.
 */
package brennus.model;

import brennus.model.ExceptionHandlingVisitor;
import brennus.model.Expression;
import brennus.model.ExpressionVisitor;
import brennus.model.UnaryOperator;

public final class UnaryExpression
extends Expression {
    private final UnaryOperator operator;
    private final Expression expression;

    public UnaryExpression(UnaryOperator operator, Expression expression) {
        this.operator = operator;
        this.expression = expression;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        ExceptionHandlingVisitor.wrap(expressionVisitor).visit(this);
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        return "[" + this.getOperator().getRepresentation() + " " + this.expression + "]";
    }
}

