/*
 * Decompiled with CFR 0.152.
 */
package brennus.printer;

import brennus.ImmutableList;
import brennus.model.BinaryExpression;
import brennus.model.CallConstructorExpression;
import brennus.model.CallMethodExpression;
import brennus.model.CastExpression;
import brennus.model.ExistingType;
import brennus.model.Expression;
import brennus.model.ExpressionVisitor;
import brennus.model.GetExpression;
import brennus.model.InstanceOfExpression;
import brennus.model.InstantiationExpression;
import brennus.model.LiteralExpression;
import brennus.model.NewArrayExpression;
import brennus.model.UnaryExpression;

class ExpressionStringifierVisitor
implements ExpressionVisitor {
    private StringBuilder sb = new StringBuilder();

    ExpressionStringifierVisitor() {
    }

    @Override
    public void visit(LiteralExpression literalExpression) {
        if (literalExpression.getType().equals(ExistingType.STRING)) {
            this.sb.append("\"");
        }
        this.sb.append(literalExpression.getValue());
        if (literalExpression.getType().equals(ExistingType.STRING)) {
            this.sb.append("\"");
        }
    }

    @Override
    public void visit(GetExpression getFieldExpression) {
        this.sb.append(getFieldExpression.getFieldName());
    }

    @Override
    public void visit(CallMethodExpression callMethodExpression) {
        if (callMethodExpression.getCallee() == null) {
            this.sb.append("this");
        } else {
            callMethodExpression.getCallee().accept(this);
        }
        this.sb.append("." + callMethodExpression.getMethodName() + "(");
        boolean first = true;
        ImmutableList<Expression> parameters = callMethodExpression.getParameters();
        for (Expression expression : parameters) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            expression.accept(this);
        }
        this.sb.append(")");
    }

    @Override
    public void visit(BinaryExpression binaryExpression) {
        this.sb.append("(");
        binaryExpression.getLeftExpression().accept(this);
        this.sb.append(" " + binaryExpression.getOperator().getRepresentation() + " ");
        binaryExpression.getRightExpression().accept(this);
        this.sb.append(")");
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void visit(UnaryExpression unaryExpression) {
        this.sb.append("(");
        this.sb.append(unaryExpression.getOperator().getRepresentation()).append(" ");
        unaryExpression.getExpression().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(InstanceOfExpression instanceOfExpression) {
        this.sb.append("(");
        instanceOfExpression.getExpression().accept(this);
        this.sb.append(" instanceOf ").append(instanceOfExpression.getType().getName());
        this.sb.append(")");
    }

    @Override
    public void visit(CastExpression castExpression) {
        this.sb.append("((").append(castExpression.getType().getName()).append(")");
        castExpression.getExpression().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(CallConstructorExpression callConstructorExpression) {
        this.sb.append("super(");
        boolean first = true;
        ImmutableList<Expression> parameters = callConstructorExpression.getParameters();
        for (Expression expression : parameters) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            expression.accept(this);
        }
        this.sb.append(")");
    }

    @Override
    public void visit(InstantiationExpression instantiationExpression) {
        this.sb.append("new ").append(instantiationExpression.getType().getName()).append("(");
        boolean first = true;
        ImmutableList<Expression> parameters = instantiationExpression.getParameters();
        for (Expression expression : parameters) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            expression.accept(this);
        }
        this.sb.append(")");
    }

    @Override
    public void visit(NewArrayExpression e) {
        this.sb.append("new ").append(e.getType().getName()).append("[");
        e.getSize().accept(this);
        this.sb.append("]");
    }
}

