/*
 * Decompiled with CFR 0.152.
 */
package brennus.printer;

import brennus.ImmutableList;
import brennus.MethodContext;
import brennus.model.CallConstructorStatement;
import brennus.model.CaseBlockStatement;
import brennus.model.CaseStatement;
import brennus.model.DefineVarStatement;
import brennus.model.ExistingType;
import brennus.model.Expression;
import brennus.model.ExpressionStatement;
import brennus.model.Field;
import brennus.model.FieldAccessType;
import brennus.model.FutureType;
import brennus.model.GotoCaseStatement;
import brennus.model.GotoStatement;
import brennus.model.IfStatement;
import brennus.model.LabelStatement;
import brennus.model.LocalVariableAccessType;
import brennus.model.MemberFlags;
import brennus.model.Method;
import brennus.model.Parameter;
import brennus.model.ParameterAccessType;
import brennus.model.ReturnStatement;
import brennus.model.SetStatement;
import brennus.model.Statement;
import brennus.model.StatementVisitor;
import brennus.model.SwitchStatement;
import brennus.model.ThrowStatement;
import brennus.model.TypeVisitor;
import brennus.model.VarAccessType;
import brennus.model.VarAccessTypeVisitor;
import brennus.printer.ExpressionStringifierVisitor;

class TypePrinterVisitor
implements TypeVisitor,
StatementVisitor {
    private int indent;
    private MethodContext context;

    TypePrinterVisitor() {
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            System.out.print(" ");
        }
    }

    private void println() {
        System.out.println();
    }

    private void println(Object ln) {
        this.printIndent();
        System.out.println(ln);
    }

    private void decIndent() {
        this.indent -= 2;
    }

    private void incIndent() {
        this.indent += 2;
    }

    private void printMethods(FutureType type, String typeName, Iterable<Method> methods) {
        for (Method m : methods) {
            this.context = new MethodContext(type, m);
            String methodName = m.getName();
            String returnType = m.getReturnType().getName();
            if (methodName.equals("<init>")) {
                this.println(this.getKeywords(m.getFlags()) + " " + typeName + "(" + this.paramString(m.getParameters()) + ") {");
            } else {
                this.println(this.getKeywords(m.getFlags()) + " " + returnType + " " + methodName + "(" + this.paramString(m.getParameters()) + ") {");
            }
            this.incIndent();
            for (Statement s : m.getStatements()) {
                s.accept(this);
            }
            this.decIndent();
            this.println("}");
            this.println();
        }
    }

    private String paramString(Iterable<Parameter> parameters) {
        String result = null;
        for (Parameter parameter : parameters) {
            result = result == null ? "" : result + ", ";
            result = result + parameter.getType().getName() + " " + parameter.getName();
        }
        return result == null ? "" : result;
    }

    private String getKeywords(MemberFlags m) {
        return (m.isStatic() ? "static " : "") + m.getProtection().name().toLowerCase();
    }

    private void printFields(Iterable<Field> fields) {
        for (Field f : fields) {
            this.println(this.getKeywords(f.getFlags()) + " " + f.getType().getName() + " " + f.getName() + ";");
        }
    }

    @Override
    public void visit(ExistingType existingType) {
        this.println(existingType.getExisting());
    }

    @Override
    public void visit(FutureType futureType) {
        String name;
        int lastDot = futureType.getName().lastIndexOf(46);
        if (lastDot == -1) {
            name = futureType.getName();
        } else {
            name = futureType.getName().substring(lastDot + 1);
            this.println("package " + futureType.getName().substring(0, lastDot) + ";");
        }
        this.println("class " + name + (futureType.getExtending() == null ? "" : " extends " + futureType.getExtending().getName()) + " {");
        this.incIndent();
        this.println("// static fields");
        this.printFields(futureType.getStaticFields());
        this.println();
        this.println("// static methods");
        this.printMethods(futureType, name, futureType.getStaticMethods());
        this.println();
        this.println("// fields");
        this.printFields(futureType.getFields());
        this.println();
        this.println("// constructors");
        this.printMethods(futureType, name, futureType.getConstructors());
        this.println();
        this.println("// methods");
        this.printMethods(futureType, name, futureType.getMethods());
        this.println();
        this.decIndent();
        this.println("}");
    }

    @Override
    public void visit(ReturnStatement returnStatement) {
        this.println("return " + this.toString(returnStatement.getExpression()) + "; // line " + returnStatement.getLine());
    }

    @Override
    public void visit(ThrowStatement throwStatement) {
        this.println("throw " + this.toString(throwStatement.getExpression()) + "; // line " + throwStatement.getLine());
    }

    @Override
    public void visit(ExpressionStatement expressionStatement) {
        this.println(this.toString(expressionStatement.getExpression()) + "; // line " + expressionStatement.getLine());
    }

    private String toString(Expression expression) {
        ExpressionStringifierVisitor expressionVisitor = new ExpressionStringifierVisitor();
        expression.accept(expressionVisitor);
        return expressionVisitor.toString();
    }

    @Override
    public void visit(SwitchStatement switchStatement) {
        this.println("switch (" + this.toString(switchStatement.getExpression()) + ") { // line " + switchStatement.getLine());
        this.incIndent();
        ImmutableList<CaseStatement> caseStatements = switchStatement.getCaseStatements();
        for (CaseStatement caseStatement : caseStatements) {
            caseStatement.accept(this);
        }
        if (switchStatement.getDefaultCaseStatement() != null) {
            switchStatement.getDefaultCaseStatement().accept(this);
        }
        this.decIndent();
        this.println("}");
    }

    @Override
    public void visit(CaseBlockStatement caseStatement) {
        String caseType = caseStatement.getExpression() == null ? "default" : "case " + this.toString(caseStatement.getExpression());
        this.println(caseType + ": // line " + caseStatement.getLine());
        this.incIndent();
        ImmutableList<Statement> statements = caseStatement.getStatements();
        for (Statement statement : statements) {
            statement.accept(this);
        }
        this.decIndent();
        if (caseStatement.isBreakCase()) {
            this.println("break;");
        }
    }

    @Override
    public void visit(final SetStatement setStatement) {
        VarAccessType varAccessType = this.context.getVarAccessType(setStatement.getTo());
        varAccessType.accept(new VarAccessTypeVisitor(){

            @Override
            public void visit(LocalVariableAccessType localVariableAccessType) {
                this.print("", " // local variable");
            }

            @Override
            public void visit(ParameterAccessType parameterAccessType) {
                this.print("", " // parameter");
            }

            @Override
            public void visit(FieldAccessType fieldAccessType) {
                this.print("this.", " // field");
            }

            private void print(String prefix, String suffix) {
                TypePrinterVisitor.this.println(prefix + setStatement.getTo() + " = " + TypePrinterVisitor.this.toString(setStatement.getExpression()) + ";" + suffix + " line " + setStatement.getLine());
            }
        });
    }

    @Override
    public void visit(IfStatement ifStatement) {
        this.println("if (" + this.toString(ifStatement.getExpression()) + ") { // line " + ifStatement.getLine());
        this.incIndent();
        for (Statement statement : ifStatement.getThenStatements()) {
            statement.accept(this);
        }
        this.decIndent();
        if (ifStatement.getElseStatements().size() > 0) {
            this.println("} else {");
            this.incIndent();
            for (Statement statement : ifStatement.getElseStatements()) {
                statement.accept(this);
            }
            this.decIndent();
        }
        this.println("}");
    }

    @Override
    public void visit(LabelStatement labelStatement) {
        this.println(labelStatement.getName() + ": // line " + labelStatement.getLine());
    }

    @Override
    public void visit(GotoStatement gotoStatement) {
        this.println("goto " + gotoStatement.getName() + "; // line " + gotoStatement.getLine());
    }

    @Override
    public void visit(CallConstructorStatement callConstructorStatement) {
        this.println(this.toString(callConstructorStatement.getExpression()) + "; // line " + callConstructorStatement.getLine());
    }

    @Override
    public void visit(DefineVarStatement defineVarStatement) {
        this.context.defineLocalVar(defineVarStatement.getType(), defineVarStatement.getVarName());
        this.println(defineVarStatement.getType().getName() + " " + defineVarStatement.getVarName() + "; // line " + defineVarStatement.getLine());
    }

    @Override
    public void visit(GotoCaseStatement gotoCaseStatement) {
        String caseType = gotoCaseStatement.getExpression() == null ? "default" : "case " + this.toString(gotoCaseStatement.getExpression());
        this.println(caseType + ": // line " + gotoCaseStatement.getLine() + " goto case");
        this.incIndent();
        this.println("goto " + gotoCaseStatement.getLabel() + "; // actually directly jumping to this label");
        this.decIndent();
    }
}

