/*
 * Decompiled with CFR 0.152.
 */
package brennus.eval;

import brennus.ExpressionBuilder;
import brennus.ParamValueExpressionBuilder;
import brennus.ValueExpressionBuilder;
import brennus.eval.Expression;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class CallTreeExpression
extends Expression {
    public static MethodCallExpression call(String methodName, CallTreeExpression ... children) {
        return new MethodCallExpression(methodName, children);
    }

    public static ParamExpression param(String name) {
        return new ParamExpression(name);
    }

    public static IntLiteralExpression lit(int value) {
        return new IntLiteralExpression(value);
    }

    public static LongLiteralExpression lit(long value) {
        return new LongLiteralExpression(value);
    }

    public static FloatLiteralExpression lit(float value) {
        return new FloatLiteralExpression(value);
    }

    public static DoubleLiteralExpression lit(double value) {
        return new DoubleLiteralExpression(value);
    }

    public static StringLiteralExpression lit(String value) {
        return new StringLiteralExpression(value);
    }

    public static BooleanLiteralExpression lit(boolean value) {
        return new BooleanLiteralExpression(value);
    }

    public abstract <T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> VEB compileToExpression(ExpressionBuilder<T, EB, VEB> var1);

    public static class ParamExpression
    extends CallTreeExpression {
        private String name;

        public ParamExpression(String name) {
            this.name = name;
        }

        @Override
        public <T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> VEB compileToExpression(ExpressionBuilder<T, EB, VEB> builder) {
            return (VEB)builder.get(this.name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class StringLiteralExpression
    extends CallTreeExpression {
        private String value;

        public StringLiteralExpression(String value) {
            this.value = value;
        }

        @Override
        public <T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> VEB compileToExpression(ExpressionBuilder<T, EB, VEB> builder) {
            return (VEB)builder.literal(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class DoubleLiteralExpression
    extends CallTreeExpression {
        private double value;

        public DoubleLiteralExpression(double value) {
            this.value = value;
        }

        @Override
        public <T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> VEB compileToExpression(ExpressionBuilder<T, EB, VEB> builder) {
            return (VEB)builder.literal(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class FloatLiteralExpression
    extends CallTreeExpression {
        private float value;

        public FloatLiteralExpression(float value) {
            this.value = value;
        }

        @Override
        public <T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> VEB compileToExpression(ExpressionBuilder<T, EB, VEB> builder) {
            return (VEB)builder.literal(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class LongLiteralExpression
    extends CallTreeExpression {
        private long value;

        public LongLiteralExpression(long value) {
            this.value = value;
        }

        @Override
        public <T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> VEB compileToExpression(ExpressionBuilder<T, EB, VEB> builder) {
            return (VEB)builder.literal(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class IntLiteralExpression
    extends CallTreeExpression {
        private int value;

        public IntLiteralExpression(int value) {
            this.value = value;
        }

        @Override
        public <T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> VEB compileToExpression(ExpressionBuilder<T, EB, VEB> builder) {
            return (VEB)builder.literal(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class BooleanLiteralExpression
    extends CallTreeExpression {
        private boolean value;

        public BooleanLiteralExpression(boolean value) {
            this.value = value;
        }

        @Override
        public <T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> VEB compileToExpression(ExpressionBuilder<T, EB, VEB> builder) {
            return (VEB)builder.literal(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class MethodCallExpression
    extends CallTreeExpression {
        private final String methodName;
        private final List<CallTreeExpression> children;

        public MethodCallExpression(String methodName, CallTreeExpression ... children) {
            this.methodName = methodName;
            this.children = Arrays.asList(children);
        }

        @Override
        public <T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> VEB compileToExpression(ExpressionBuilder<T, EB, VEB> builder) {
            if (this.children.size() == 0) {
                return (VEB)builder.callOnThisNoParam(this.methodName);
            }
            Iterator<CallTreeExpression> it = this.children.iterator();
            ParamValueExpressionBuilder veb = (ParamValueExpressionBuilder)it.next().compileToExpression(builder.callOnThis(this.methodName));
            while (it.hasNext()) {
                veb = (ParamValueExpressionBuilder)it.next().compileToExpression(veb.nextParam());
            }
            return (VEB)((ValueExpressionBuilder)veb.endCall());
        }

        public String toString() {
            String s = this.methodName + "(";
            boolean first = true;
            for (CallTreeExpression child : this.children) {
                if (first) {
                    first = false;
                } else {
                    s = s + ", ";
                }
                s = s + child.toString();
            }
            s = s + ")";
            return s;
        }
    }
}

