/*
 * Decompiled with CFR 0.152.
 */
package brennus.eval;

import brennus.eval.Expression;
import brennus.eval.Parameters;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class DynamicExpression
extends Expression {
    public final Type returnType;

    public DynamicExpression(Type returnType) {
        this.returnType = returnType;
    }

    public abstract <T> T accept(ExpressionVisitor<T> var1);

    public static interface ExpressionVisitor<T> {
        public T visit(BinaryExpression var1);

        public T visit(CastExpression var1);

        public T visit(ParamExpression var1);

        public T visit(ConstantExpression var1);

        public T visit(UnaryExpression var1);
    }

    public static final class CastExpression
    extends DynamicExpression {
        public final DynamicExpression castedExpression;

        public CastExpression(Type type, DynamicExpression castedExpression) {
            super(type);
            this.castedExpression = castedExpression;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> v) {
            return v.visit(this);
        }

        public String toString() {
            return "(" + (Object)((Object)this.returnType) + ")" + this.castedExpression.toString();
        }

        @Override
        public int evalInt(Parameters p) {
            switch (this.castedExpression.returnType) {
                case INT: {
                    return this.castedExpression.evalInt(p);
                }
                case LONG: {
                    return (int)this.castedExpression.evalLong(p);
                }
                case FLOAT: {
                    return (int)this.castedExpression.evalFloat(p);
                }
                case DOUBLE: {
                    return (int)this.castedExpression.evalDouble(p);
                }
                case BOOLEAN: {
                    return this.castedExpression.evalBoolean(p) ? 0 : 1;
                }
            }
            throw new UnsupportedOperationException(this.castedExpression.returnType.name());
        }

        @Override
        public long evalLong(Parameters p) {
            switch (this.castedExpression.returnType) {
                case INT: {
                    return this.castedExpression.evalInt(p);
                }
                case LONG: {
                    return this.castedExpression.evalLong(p);
                }
                case FLOAT: {
                    return (long)this.castedExpression.evalFloat(p);
                }
                case DOUBLE: {
                    return (long)this.castedExpression.evalDouble(p);
                }
                case BOOLEAN: {
                    return this.castedExpression.evalBoolean(p) ? 0L : 1L;
                }
            }
            throw new UnsupportedOperationException(this.castedExpression.returnType.name());
        }

        @Override
        public float evalFloat(Parameters p) {
            switch (this.castedExpression.returnType) {
                case INT: {
                    return this.castedExpression.evalInt(p);
                }
                case LONG: {
                    return this.castedExpression.evalLong(p);
                }
                case FLOAT: {
                    return this.castedExpression.evalFloat(p);
                }
                case DOUBLE: {
                    return (float)this.castedExpression.evalDouble(p);
                }
                case BOOLEAN: {
                    return this.castedExpression.evalBoolean(p) ? 0.0f : 1.0f;
                }
            }
            throw new UnsupportedOperationException(this.castedExpression.returnType.name());
        }

        @Override
        public double evalDouble(Parameters p) {
            switch (this.castedExpression.returnType) {
                case INT: {
                    return this.castedExpression.evalInt(p);
                }
                case LONG: {
                    return this.castedExpression.evalLong(p);
                }
                case FLOAT: {
                    return this.castedExpression.evalFloat(p);
                }
                case DOUBLE: {
                    return this.castedExpression.evalDouble(p);
                }
                case BOOLEAN: {
                    return this.castedExpression.evalBoolean(p) ? 0.0 : 1.0;
                }
            }
            throw new UnsupportedOperationException(this.castedExpression.returnType.name());
        }

        @Override
        public boolean evalBoolean(Parameters p) {
            switch (this.castedExpression.returnType) {
                case INT: {
                    return this.castedExpression.evalInt(p) == 0;
                }
                case LONG: {
                    return this.castedExpression.evalLong(p) == 0L;
                }
                case FLOAT: {
                    return this.castedExpression.evalFloat(p) == 0.0f;
                }
                case DOUBLE: {
                    return this.castedExpression.evalDouble(p) == 0.0;
                }
                case BOOLEAN: {
                    return this.castedExpression.evalBoolean(p);
                }
            }
            throw new UnsupportedOperationException(this.castedExpression.returnType.name());
        }
    }

    public static final class ParamExpression
    extends DynamicExpression {
        public final int index;

        public ParamExpression(Type type, int index) {
            super(type);
            this.index = index;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> v) {
            return v.visit(this);
        }

        public String toString() {
            return this.returnType.name() + "[" + this.index + "]";
        }

        @Override
        public int evalInt(Parameters p) {
            return p.getInt(this.index);
        }

        @Override
        public long evalLong(Parameters p) {
            return p.getLong(this.index);
        }

        @Override
        public float evalFloat(Parameters p) {
            return p.getFloat(this.index);
        }

        @Override
        public double evalDouble(Parameters p) {
            return p.getDouble(this.index);
        }

        @Override
        public boolean evalBoolean(Parameters p) {
            return p.getBoolean(this.index);
        }
    }

    public static final class ConstantExpression
    extends DynamicExpression {
        public final Object value;

        public ConstantExpression(Type type, Object value) {
            super(type);
            this.value = value;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> v) {
            return v.visit(this);
        }

        public String toString() {
            return this.value.toString() + this.returnType.name();
        }

        @Override
        public int evalInt(Parameters p) {
            return (Integer)this.value;
        }

        @Override
        public long evalLong(Parameters p) {
            return (Long)this.value;
        }

        @Override
        public float evalFloat(Parameters p) {
            return ((Float)this.value).floatValue();
        }

        @Override
        public double evalDouble(Parameters p) {
            return (Double)this.value;
        }

        @Override
        public boolean evalBoolean(Parameters p) {
            return (Boolean)this.value;
        }
    }

    public static final class UnaryExpression
    extends DynamicExpression {
        public final UnaryOperator operator;
        public final DynamicExpression operand;

        public UnaryExpression(UnaryOperator operator, DynamicExpression operand) {
            super(operator.validateType(operand));
            this.operator = operator;
            this.operand = operand;
        }

        @Override
        public int evalInt(Parameters p) {
            return this.operator.evalInt(this.operand.evalInt(p));
        }

        @Override
        public long evalLong(Parameters p) {
            return this.operator.evalLong(this.operand.evalLong(p));
        }

        @Override
        public float evalFloat(Parameters p) {
            return this.operator.evalFloat(this.operand.evalFloat(p));
        }

        @Override
        public double evalDouble(Parameters p) {
            return this.operator.evalDouble(this.operand.evalDouble(p));
        }

        @Override
        public boolean evalBoolean(Parameters p) {
            return this.operator.evalBoolean(this.operand.evalBoolean(p));
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> v) {
            return v.visit(this);
        }

        public static enum UnaryOperator {
            MINUS{

                @Override
                public Type validateType(DynamicExpression operand) {
                    if (operand.returnType == Type.BOOLEAN) {
                        throw new IllegalArgumentException("can't minus BOOLEAN");
                    }
                    return operand.returnType;
                }

                @Override
                public int evalInt(int val) {
                    return -val;
                }

                @Override
                public long evalLong(long val) {
                    return -val;
                }

                @Override
                public float evalFloat(float val) {
                    return -val;
                }

                @Override
                public double evalDouble(double val) {
                    return -val;
                }

                @Override
                public boolean evalBoolean(boolean val) {
                    throw new UnsupportedOperationException();
                }
            }
            ,
            NOT{

                @Override
                public Type validateType(DynamicExpression operand) {
                    if (operand.returnType != Type.BOOLEAN) {
                        throw new IllegalArgumentException("can't not " + (Object)((Object)operand.returnType));
                    }
                    return operand.returnType;
                }

                @Override
                public int evalInt(int val) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public long evalLong(long val) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public float evalFloat(float val) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public double evalDouble(double val) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean evalBoolean(boolean val) {
                    return !val;
                }
            };


            public abstract Type validateType(DynamicExpression var1);

            public abstract int evalInt(int var1);

            public abstract long evalLong(long var1);

            public abstract float evalFloat(float var1);

            public abstract double evalDouble(double var1);

            public abstract boolean evalBoolean(boolean var1);
        }
    }

    public static interface BinaryOperatorVisitor<T> {
        public T visit(BinaryExpression.ArithmeticOperator var1);

        public T visit(BinaryExpression.ComparisonOperator var1);

        public T visit(BinaryExpression.BooleanOperator var1);
    }

    public static final class BinaryExpression
    extends DynamicExpression {
        public final BinaryOperator operator;
        public final DynamicExpression left;
        public final DynamicExpression right;

        public BinaryExpression(BinaryOperator operator, DynamicExpression left, DynamicExpression right) {
            super(operator.validateTypes(left, right));
            this.operator = operator;
            this.left = left;
            this.right = right;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> v) {
            return v.visit(this);
        }

        public String toString() {
            return this.operator + "(" + this.left + ", " + this.right + ")";
        }

        @Override
        public int evalInt(Parameters p) {
            return this.operator.evalInt(this.left, this.right, p);
        }

        @Override
        public long evalLong(Parameters p) {
            return this.operator.evalLong(this.left, this.right, p);
        }

        @Override
        public float evalFloat(Parameters p) {
            return this.operator.evalFloat(this.left, this.right, p);
        }

        @Override
        public double evalDouble(Parameters p) {
            return this.operator.evalDouble(this.left, this.right, p);
        }

        @Override
        public boolean evalBoolean(Parameters p) {
            return this.operator.evalBoolean(this.left, this.right, p);
        }

        public static enum ComparisonOperator implements BinaryOperator
        {
            GT{

                @Override
                public boolean eval(int left, int right) {
                    return left > right;
                }

                @Override
                public boolean eval(long left, long right) {
                    return left > right;
                }

                @Override
                public boolean eval(float left, float right) {
                    return left > right;
                }

                @Override
                public boolean eval(double left, double right) {
                    return left > right;
                }
            }
            ,
            LT{

                @Override
                public boolean eval(int left, int right) {
                    return left < right;
                }

                @Override
                public boolean eval(long left, long right) {
                    return left < right;
                }

                @Override
                public boolean eval(float left, float right) {
                    return left < right;
                }

                @Override
                public boolean eval(double left, double right) {
                    return left < right;
                }
            }
            ,
            EQ{

                @Override
                public boolean eval(int left, int right) {
                    return left == right;
                }

                @Override
                public boolean eval(long left, long right) {
                    return left == right;
                }

                @Override
                public boolean eval(float left, float right) {
                    return left == right;
                }

                @Override
                public boolean eval(double left, double right) {
                    return left == right;
                }
            }
            ,
            GE{

                @Override
                public boolean eval(int left, int right) {
                    return left >= right;
                }

                @Override
                public boolean eval(long left, long right) {
                    return left >= right;
                }

                @Override
                public boolean eval(float left, float right) {
                    return left >= right;
                }

                @Override
                public boolean eval(double left, double right) {
                    return left >= right;
                }
            }
            ,
            LE{

                @Override
                public boolean eval(int left, int right) {
                    return left <= right;
                }

                @Override
                public boolean eval(long left, long right) {
                    return left <= right;
                }

                @Override
                public boolean eval(float left, float right) {
                    return left <= right;
                }

                @Override
                public boolean eval(double left, double right) {
                    return left <= right;
                }
            }
            ,
            NE{

                @Override
                public boolean eval(int left, int right) {
                    return left != right;
                }

                @Override
                public boolean eval(long left, long right) {
                    return left != right;
                }

                @Override
                public boolean eval(float left, float right) {
                    return left != right;
                }

                @Override
                public boolean eval(double left, double right) {
                    return left != right;
                }
            };


            protected abstract boolean eval(int var1, int var2);

            protected abstract boolean eval(long var1, long var3);

            protected abstract boolean eval(float var1, float var2);

            protected abstract boolean eval(double var1, double var3);

            @Override
            public Type validateTypes(DynamicExpression left, DynamicExpression right) {
                if (left.returnType != right.returnType) {
                    throw new UnsupportedOperationException((Object)((Object)left.returnType) + " != " + (Object)((Object)right.returnType));
                }
                return Type.BOOLEAN;
            }

            @Override
            public int evalInt(DynamicExpression left, DynamicExpression right, Parameters p) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long evalLong(DynamicExpression left, DynamicExpression right, Parameters p) {
                throw new UnsupportedOperationException();
            }

            @Override
            public float evalFloat(DynamicExpression left, DynamicExpression right, Parameters p) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double evalDouble(DynamicExpression left, DynamicExpression right, Parameters p) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean evalBoolean(DynamicExpression left, DynamicExpression right, Parameters p) {
                switch (left.returnType) {
                    case INT: {
                        return this.eval(left.evalInt(p), right.evalInt(p));
                    }
                    case LONG: {
                        return this.eval(left.evalLong(p), right.evalLong(p));
                    }
                    case FLOAT: {
                        return this.eval(left.evalFloat(p), right.evalFloat(p));
                    }
                    case DOUBLE: {
                        return this.eval(left.evalDouble(p), right.evalDouble(p));
                    }
                }
                throw new UnsupportedOperationException(left.returnType.name());
            }

            @Override
            public <T> T accept(BinaryOperatorVisitor<T> v) {
                return v.visit(this);
            }
        }

        public static enum BooleanOperator implements BinaryOperator
        {
            AND{

                @Override
                public boolean eval(boolean left, DynamicExpression right, Parameters parameters) {
                    return left && right.evalBoolean(parameters);
                }
            }
            ,
            OR{

                @Override
                public boolean eval(boolean left, DynamicExpression right, Parameters parameters) {
                    return left || right.evalBoolean(parameters);
                }
            }
            ,
            XOR{

                @Override
                public boolean eval(boolean left, DynamicExpression right, Parameters parameters) {
                    return left ^ right.evalBoolean(parameters);
                }
            };


            @Override
            public int evalInt(DynamicExpression left, DynamicExpression right, Parameters p) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long evalLong(DynamicExpression left, DynamicExpression right, Parameters p) {
                throw new UnsupportedOperationException();
            }

            @Override
            public float evalFloat(DynamicExpression left, DynamicExpression right, Parameters p) {
                throw new UnsupportedOperationException();
            }

            @Override
            public double evalDouble(DynamicExpression left, DynamicExpression right, Parameters p) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean evalBoolean(DynamicExpression left, DynamicExpression right, Parameters p) {
                return this.eval(left.evalBoolean(p), right, p);
            }

            protected abstract boolean eval(boolean var1, DynamicExpression var2, Parameters var3);

            @Override
            public <T> T accept(BinaryOperatorVisitor<T> v) {
                return v.visit(this);
            }

            @Override
            public Type validateTypes(DynamicExpression left, DynamicExpression right) {
                if (left.returnType != Type.BOOLEAN || right.returnType != Type.BOOLEAN) {
                    throw new IllegalArgumentException((Object)((Object)left.returnType) + " and " + (Object)((Object)right.returnType) + " should both be BOOLEAN");
                }
                return Type.BOOLEAN;
            }
        }

        public static enum ArithmeticOperator implements BinaryOperator
        {
            PLUS{

                @Override
                public int eval(int left, int right) {
                    return left + right;
                }

                @Override
                public long eval(long left, long right) {
                    return left + right;
                }

                @Override
                public float eval(float left, float right) {
                    return left + right;
                }

                @Override
                public double eval(double left, double right) {
                    return left + right;
                }
            }
            ,
            MINUS{

                @Override
                public int eval(int left, int right) {
                    return left - right;
                }

                @Override
                public long eval(long left, long right) {
                    return left - right;
                }

                @Override
                public float eval(float left, float right) {
                    return left - right;
                }

                @Override
                public double eval(double left, double right) {
                    return left - right;
                }
            }
            ,
            MULTIPLY{

                @Override
                public int eval(int left, int right) {
                    return left * right;
                }

                @Override
                public long eval(long left, long right) {
                    return left * right;
                }

                @Override
                public float eval(float left, float right) {
                    return left * right;
                }

                @Override
                public double eval(double left, double right) {
                    return left * right;
                }
            }
            ,
            DIVIDE{

                @Override
                public int eval(int left, int right) {
                    return left / right;
                }

                @Override
                public long eval(long left, long right) {
                    return left / right;
                }

                @Override
                public float eval(float left, float right) {
                    return left / right;
                }

                @Override
                public double eval(double left, double right) {
                    return left / right;
                }
            };


            public abstract int eval(int var1, int var2);

            public abstract long eval(long var1, long var3);

            public abstract float eval(float var1, float var2);

            public abstract double eval(double var1, double var3);

            @Override
            public int evalInt(DynamicExpression left, DynamicExpression right, Parameters p) {
                return this.eval(left.evalInt(p), right.evalInt(p));
            }

            @Override
            public long evalLong(DynamicExpression left, DynamicExpression right, Parameters p) {
                return this.eval(left.evalLong(p), right.evalLong(p));
            }

            @Override
            public float evalFloat(DynamicExpression left, DynamicExpression right, Parameters p) {
                return this.eval(left.evalFloat(p), right.evalFloat(p));
            }

            @Override
            public double evalDouble(DynamicExpression left, DynamicExpression right, Parameters p) {
                return this.eval(left.evalDouble(p), right.evalDouble(p));
            }

            @Override
            public boolean evalBoolean(DynamicExpression left, DynamicExpression right, Parameters p) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T accept(BinaryOperatorVisitor<T> v) {
                return v.visit(this);
            }

            @Override
            public Type validateTypes(DynamicExpression left, DynamicExpression right) {
                if (left.returnType != right.returnType) {
                    throw new IllegalArgumentException((Object)((Object)left.returnType) + " " + (Object)((Object)right.returnType) + " should be the same");
                }
                return left.returnType;
            }
        }

        public static interface BinaryOperator {
            public <T> T accept(BinaryOperatorVisitor<T> var1);

            public Type validateTypes(DynamicExpression var1, DynamicExpression var2);

            public int evalInt(DynamicExpression var1, DynamicExpression var2, Parameters var3);

            public long evalLong(DynamicExpression var1, DynamicExpression var2, Parameters var3);

            public float evalFloat(DynamicExpression var1, DynamicExpression var2, Parameters var3);

            public double evalDouble(DynamicExpression var1, DynamicExpression var2, Parameters var3);

            public boolean evalBoolean(DynamicExpression var1, DynamicExpression var2, Parameters var3);
        }
    }

    public static enum Type {
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN;

        public static final List<Type> numericTypes;

        static {
            numericTypes = Collections.unmodifiableList(Arrays.asList(INT, LONG, FLOAT, DOUBLE));
        }
    }
}

