/*
 * Decompiled with CFR 0.152.
 */
package brennus.eval;

import brennus.Builder;
import brennus.ExpressionBuilder;
import brennus.MethodBuilder;
import brennus.ParamValueExpressionBuilder;
import brennus.ReturnExpressionBuilder;
import brennus.ReturnValueExpressionBuilder;
import brennus.ValueExpressionBuilder;
import brennus.asm.DynamicClassLoader;
import brennus.eval.DynamicExpression;
import brennus.eval.Expression;
import brennus.eval.GeneratedExpression;
import brennus.eval.Parameters;
import brennus.model.ExistingType;
import brennus.model.FutureType;
import brennus.model.PrimitiveType;
import brennus.model.Protection;
import brennus.model.Type;

public class ExpressionCompiler {
    private DynamicClassLoader cl = new DynamicClassLoader();
    private static int id = 0;

    public Expression compileExpression(DynamicExpression e) {
        PrimitiveType type;
        switch (e.returnType) {
            case INT: {
                type = ExistingType.INT;
                break;
            }
            case LONG: {
                type = ExistingType.LONG;
                break;
            }
            case FLOAT: {
                type = ExistingType.FLOAT;
                break;
            }
            case DOUBLE: {
                type = ExistingType.DOUBLE;
                break;
            }
            case BOOLEAN: {
                type = ExistingType.BOOLEAN;
                break;
            }
            default: {
                throw new UnsupportedOperationException(e.returnType.name());
            }
        }
        ReturnExpressionBuilder b = new Builder().startClass("brennus.eval.ExpressionCompiler$Expression" + ++id, (Type)ExistingType.existing(GeneratedExpression.class)).startMethod(Protection.PUBLIC, (Type)type, ExpressionCompiler.camelCase("eval", e.returnType.name())).param((Type)ExistingType.existing(Parameters.class), "parameters").returnExp();
        FutureType c = ((MethodBuilder)((ReturnValueExpressionBuilder)this.eval((ExpressionBuilder)b, e)).endReturn()).endMethod().endClass();
        this.cl.define(c);
        try {
            return (Expression)this.cl.loadClass(c.getName()).newInstance();
        }
        catch (InstantiationException e1) {
            throw new RuntimeException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1);
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException(e1);
        }
    }

    private <T, EB, VEB extends ValueExpressionBuilder<T, EB, VEB>> VEB eval(final ExpressionBuilder<T, EB, VEB> b, DynamicExpression e) {
        return (VEB)((ValueExpressionBuilder)e.accept(new DynamicExpression.ExpressionVisitor<VEB>(){

            @Override
            public VEB visit(final DynamicExpression.BinaryExpression e) {
                String methodName = e.operator.accept(new DynamicExpression.BinaryOperatorVisitor<String>(){

                    @Override
                    public String visit(DynamicExpression.BinaryExpression.ArithmeticOperator o) {
                        return ExpressionCompiler.camelCase(o.name(), e.returnType.name());
                    }

                    @Override
                    public String visit(DynamicExpression.BinaryExpression.ComparisonOperator o) {
                        DynamicExpression.Type type = e.left.returnType;
                        return ExpressionCompiler.camelCase(o.name(), type.name());
                    }

                    @Override
                    public String visit(DynamicExpression.BinaryExpression.BooleanOperator o) {
                        return ExpressionCompiler.camelCase(o.name());
                    }
                });
                return (ValueExpressionBuilder)((ParamValueExpressionBuilder)ExpressionCompiler.this.eval((ExpressionBuilder)((ParamValueExpressionBuilder)ExpressionCompiler.this.eval((ExpressionBuilder)b.callOnThis(methodName), e.left)).nextParam(), e.right)).endCall();
            }

            @Override
            public VEB visit(DynamicExpression.ParamExpression e) {
                return (ValueExpressionBuilder)((ParamValueExpressionBuilder)b.get("parameters").call(ExpressionCompiler.camelCase("get", e.returnType.name())).literal(e.index)).endCall();
            }

            @Override
            public VEB visit(DynamicExpression.ConstantExpression e) {
                switch (e.returnType) {
                    case INT: {
                        return b.literal(((Integer)e.value).intValue());
                    }
                    case LONG: {
                        return b.literal(((Long)e.value).longValue());
                    }
                    case FLOAT: {
                        return b.literal(((Float)e.value).floatValue());
                    }
                    case DOUBLE: {
                        return b.literal(((Double)e.value).doubleValue());
                    }
                    case BOOLEAN: {
                        return b.literal(((Boolean)e.value).booleanValue());
                    }
                }
                throw new UnsupportedOperationException(e.returnType.name());
            }

            @Override
            public VEB visit(DynamicExpression.UnaryExpression e) {
                String name = e.operator == DynamicExpression.UnaryExpression.UnaryOperator.MINUS ? ExpressionCompiler.camelCase(e.operator.name(), e.returnType.name()) : ExpressionCompiler.camelCase(e.operator.name());
                return (ValueExpressionBuilder)((ParamValueExpressionBuilder)ExpressionCompiler.this.eval((ExpressionBuilder)b.callOnThis(name), e.operand)).endCall();
            }

            @Override
            public VEB visit(DynamicExpression.CastExpression e) {
                return (ValueExpressionBuilder)((ParamValueExpressionBuilder)ExpressionCompiler.this.eval((ExpressionBuilder)b.callOnThis(ExpressionCompiler.camelCase("cast", e.returnType.name(), e.castedExpression.returnType.name())), e.castedExpression)).endCall();
            }
        }));
    }

    public static String camelCase(String ... s) {
        StringBuilder sb = new StringBuilder();
        if (s.length > 0) {
            sb.append(s[0].toLowerCase());
            for (int i = 1; i < s.length; ++i) {
                if (s[i].length() <= 0) continue;
                sb.append(s[i].substring(0, 1).toUpperCase());
                sb.append(s[i].substring(1).toLowerCase());
            }
        }
        return sb.toString();
    }
}

