/*
 * Decompiled with CFR 0.152.
 */
package brennus.eval;

import java.util.Arrays;

public interface Parameters {
    public int getInt(int var1);

    public long getLong(int var1);

    public double getDouble(int var1);

    public float getFloat(int var1);

    public boolean getBoolean(int var1);

    public static class ParametersArray
    extends ParametersBase {
        private final Object[] params;

        public ParametersArray(Object ... params) {
            this.params = params;
        }

        @Override
        public int getInt(int index) {
            return (Integer)this.params[index];
        }

        @Override
        public long getLong(int index) {
            return (Long)this.params[index];
        }

        @Override
        public double getDouble(int index) {
            return (Double)this.params[index];
        }

        @Override
        public float getFloat(int index) {
            return ((Float)this.params[index]).floatValue();
        }

        @Override
        public boolean getBoolean(int index) {
            return (Boolean)this.params[index];
        }

        public String toString() {
            return Arrays.toString(this.params);
        }
    }

    public static class ParametersBase
    implements Parameters {
        @Override
        public int getInt(int index) {
            throw new UnsupportedOperationException("NYI");
        }

        @Override
        public long getLong(int index) {
            throw new UnsupportedOperationException("NYI");
        }

        @Override
        public double getDouble(int index) {
            throw new UnsupportedOperationException("NYI");
        }

        @Override
        public float getFloat(int index) {
            throw new UnsupportedOperationException("NYI");
        }

        @Override
        public boolean getBoolean(int index) {
            throw new UnsupportedOperationException("NYI");
        }
    }
}

