/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.additionalclassprovider;

import com.google.common.reflect.ClassPath;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.utils.Sneaky;
import net.lenni0451.classtransform.utils.tree.BasicClassProvider;

@ParametersAreNonnullByDefault
public class GuavaClassPathProvider
extends BasicClassProvider {
    private final ClassPath classPath;

    public GuavaClassPathProvider() {
        this(GuavaClassPathProvider.class.getClassLoader());
    }

    public GuavaClassPathProvider(ClassLoader classLoader) {
        super(classLoader);
        try {
            this.classPath = ClassPath.from((ClassLoader)classLoader);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to initialize ClassPath", t);
        }
    }

    @Nonnull
    public Map<String, Supplier<byte[]>> getAllClasses() {
        HashMap<String, Supplier<byte[]>> map = new HashMap<String, Supplier<byte[]>>();
        for (ClassPath.ClassInfo classInfo : this.classPath.getAllClasses()) {
            map.put(classInfo.getName(), Sneaky.sneakySupply(() -> this.getClass(classInfo.getName())));
        }
        return map;
    }
}

