/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.additionalclassprovider;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.tree.IClassProvider;

@ParametersAreNonnullByDefault
public class MapClassProvider
implements IClassProvider {
    @Nullable
    private final IClassProvider parent;
    private final Map<String, byte[]> classes;
    private final NameFormat nameFormat;

    public MapClassProvider(Map<String, byte[]> classes, NameFormat nameFormat) {
        this(null, classes, nameFormat);
    }

    public MapClassProvider(Map<String, byte[]> classes, NameFormat nameFormat, @Nullable IClassProvider parent) {
        this(parent, classes, nameFormat);
    }

    public MapClassProvider(@Nullable IClassProvider parent, Map<String, byte[]> classes, NameFormat nameFormat) {
        this.parent = parent;
        this.classes = classes;
        this.nameFormat = nameFormat;
    }

    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        String formattedName = this.nameFormat.format(name);
        byte[] clazz = this.classes.get(formattedName);
        if (clazz != null) {
            return clazz;
        }
        if (this.parent != null) {
            return this.parent.getClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    @Nonnull
    public Map<String, Supplier<byte[]>> getAllClasses() {
        HashMap<String, Supplier<byte[]>> classes = this.parent != null ? this.parent.getAllClasses() : new HashMap();
        for (String name : this.classes.keySet()) {
            classes.put(this.nameFormat.toDot(name), () -> this.classes.get(name));
        }
        return classes;
    }

    public static enum NameFormat {
        DOT(ASMUtils::dot, Function.identity()),
        SLASH(ASMUtils::slash, ASMUtils::dot),
        DOT_CLASS(name -> ASMUtils.dot((String)name) + ".class", name -> ASMUtils.dot((String)name.substring(0, name.length() - 6))),
        SLASH_CLASS(name -> ASMUtils.slash((String)name) + ".class", name -> ASMUtils.dot((String)name.substring(0, name.length() - 6)));

        private final Function<String, String> formatter;
        private final Function<String, String> toDot;

        private NameFormat(Function<String, String> formatter, Function<String, String> toDot) {
            this.formatter = formatter;
            this.toDot = toDot;
        }

        public String format(String name) {
            return this.formatter.apply(name);
        }

        public String toDot(String name) {
            return this.toDot.apply(name);
        }
    }
}

