/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.classtransform.additionalclassprovider;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.Sneaky;
import net.lenni0451.classtransform.utils.tree.IClassProvider;

@ParametersAreNonnullByDefault
public class PathClassProvider
implements IClassProvider {
    @Nullable
    private final IClassProvider parent;
    private final Path path;

    public PathClassProvider(Path path) {
        this(null, path);
    }

    public PathClassProvider(Path path, @Nullable IClassProvider parent) {
        this(parent, path);
    }

    public PathClassProvider(@Nullable IClassProvider parent, Path path) {
        this.parent = parent;
        this.path = path;
    }

    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        try {
            Path path = this.path.resolve(ASMUtils.slash((String)name) + ".class");
            if (Files.exists(path, new LinkOption[0])) {
                return Files.readAllBytes(path);
            }
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(name, t);
        }
        if (this.parent != null) {
            return this.parent.getClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public Map<String, Supplier<byte[]>> getAllClasses() {
        try (Stream<Path> paths = Files.find(this.path, Integer.MAX_VALUE, (path, basicFileAttributes) -> path.getFileName().toString().endsWith(".class") && basicFileAttributes.isRegularFile(), new FileVisitOption[0]);){
            Map classes = paths.collect(HashMap::new, (m, p) -> {
                String name = ASMUtils.dot((String)this.path.relativize((Path)p).toString());
                name = name.substring(0, name.length() - 6);
                m.put(name, Sneaky.sneakySupply(() -> Files.readAllBytes(p)));
            }, Map::putAll);
            if (this.parent != null) {
                Map parentClasses = this.parent.getAllClasses();
                parentClasses.putAll(classes);
                Map map = parentClasses;
                return map;
            }
            Map map = classes;
            return map;
        }
    }
}

