/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient;

import java.io.IOException;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import net.lenni0451.commons.httpclient.HeaderStore;
import net.lenni0451.commons.httpclient.HttpRequestBuilder;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.RetryHandler;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.exceptions.RetryExceededException;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.requests.HttpContentRequest;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.utils.HttpRequestUtils;

public class HttpClient
extends HeaderStore<HttpClient>
implements HttpRequestBuilder {
    @Nullable
    private CookieManager cookieManager = new CookieManager();
    private boolean followRedirects = true;
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private RetryHandler retryHandler = new RetryHandler();

    @Nullable
    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public HttpClient setCookieManager(@Nullable CookieManager cookieManager) {
        this.cookieManager = cookieManager;
        return this;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public HttpClient setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HttpClient setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HttpClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public RetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public HttpClient setRetryHandler(RetryHandler retryHandler) {
        this.retryHandler = retryHandler;
        return this;
    }

    public <R> R execute(@Nonnull HttpRequest request, @Nonnull HttpResponseHandler<R> responseHandler) throws IOException {
        return responseHandler.handle(this.execute(request));
    }

    public HttpResponse execute(@Nonnull HttpRequest request) throws IOException {
        CookieManager cookieManager = request.isCookieManagerSet() ? request.getCookieManager() : this.cookieManager;
        RetryHandler retryHandler = request.isRetryHandlerSet() ? request.getRetryHandler() : this.retryHandler;
        for (int connects = 0; connects <= retryHandler.getMaxConnectRetries(); ++connects) {
            try {
                HttpResponse response = null;
                for (int headers = 0; headers <= retryHandler.getMaxHeaderRetries(); ++headers) {
                    HttpURLConnection connection = this.openConnection(request, cookieManager);
                    response = this.executeRequest(connection, cookieManager, request);
                    Optional<String> retryAfter = response.getFirstHeader("Retry-After");
                    if (retryAfter.isPresent()) {
                        if (headers >= retryHandler.getMaxHeaderRetries()) break;
                        Long delay = HttpRequestUtils.parseSecondsOrHttpDate(retryAfter.get());
                        if (delay == null) {
                            return response;
                        }
                        if (delay <= 0L) continue;
                        Thread.sleep(delay);
                        continue;
                    }
                    return response;
                }
                if (response == null) {
                    throw new IllegalStateException("Response not received but no exception was thrown");
                }
                if (retryHandler.getMaxHeaderRetries() == 0) {
                    return response;
                }
                throw new RetryExceededException(response);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            catch (ProtocolException | UnknownHostException | SSLException e) {
                throw e;
            }
            catch (IOException e) {
                if (connects < retryHandler.getMaxConnectRetries()) continue;
                throw e;
            }
        }
        throw new IllegalStateException("Connect retry failed but no exception was thrown");
    }

    private HttpURLConnection openConnection(HttpRequest request, CookieManager cookieManager) throws IOException {
        URL url = request.getURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setupConnection(connection, cookieManager, request);
        connection.connect();
        return connection;
    }

    private void setupConnection(@Nonnull HttpURLConnection connection, @Nullable CookieManager cookieManager, @Nonnull HttpRequest request) throws IOException {
        HttpContent content;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (request instanceof HttpContentRequest && (content = ((HttpContentRequest)request).getContent()) != null) {
            headers.put("Content-Type", Collections.singletonList(content.getContentType().toString()));
            headers.put("Content-Length", Collections.singletonList(String.valueOf(content.getContentLength())));
        }
        HttpRequestUtils.setHeaders(connection, HttpRequestUtils.mergeHeaders(HttpRequestUtils.getCookieHeaders(cookieManager, request.getURL()), headers, this.getHeaders(), request.getHeaders()));
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setRequestMethod(request.getMethod());
        connection.setDoInput(true);
        connection.setDoOutput(request instanceof HttpContentRequest && ((HttpContentRequest)request).getContent() != null);
        switch (request.getFollowRedirects()) {
            case NOT_SET: {
                connection.setInstanceFollowRedirects(this.followRedirects);
                break;
            }
            case FOLLOW: {
                connection.setInstanceFollowRedirects(true);
                break;
            }
            case IGNORE: {
                connection.setInstanceFollowRedirects(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeRequest(@Nonnull HttpURLConnection connection, @Nullable CookieManager cookieManager, @Nonnull HttpRequest request) throws IOException {
        try {
            if (connection.getDoOutput()) {
                OutputStream os = connection.getOutputStream();
                os.write(((HttpContentRequest)request).getContent().getAsBytes());
                os.flush();
            }
            byte[] body = HttpRequestUtils.readBody(connection);
            HttpResponse response = new HttpResponse(request.getURL(), connection.getResponseCode(), body, connection.getHeaderFields().entrySet().stream().filter(e -> e.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            HttpRequestUtils.updateCookies(cookieManager, request.getURL(), connection.getHeaderFields());
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            connection.disconnect();
        }
    }
}

