/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.content;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import net.lenni0451.commons.httpclient.content.impl.ByteArrayContent;
import net.lenni0451.commons.httpclient.content.impl.FileContent;
import net.lenni0451.commons.httpclient.content.impl.StringContent;
import net.lenni0451.commons.httpclient.content.impl.URLEncodedFormContent;
import net.lenni0451.commons.httpclient.model.ContentType;

public abstract class HttpContent {
    private final ContentType contentType;
    protected byte[] content;

    public static HttpContent bytes(@Nonnull byte[] content) {
        return new ByteArrayContent(content);
    }

    public static HttpContent bytes(@Nonnull byte[] content, int offset, int length) {
        return new ByteArrayContent(content, offset, length);
    }

    public static HttpContent string(@Nonnull String content) {
        return new StringContent(content);
    }

    public static HttpContent string(@Nonnull String content, @Nonnull Charset charset) {
        return new StringContent(content, charset);
    }

    public static HttpContent file(@Nonnull File file) {
        return new FileContent(file);
    }

    public static HttpContent form(@Nonnull String key, @Nonnull String value) {
        return new URLEncodedFormContent().put(key, value);
    }

    public static HttpContent form(@Nonnull Map<String, String> form) {
        return new URLEncodedFormContent(form);
    }

    public HttpContent(ContentType contentType) {
        this.contentType = contentType;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public byte[] getAsBytes() throws IOException {
        if (this.content == null) {
            this.content = this.compute();
        }
        return this.content;
    }

    public String getAsString() throws IOException {
        return this.getAsString(StandardCharsets.UTF_8);
    }

    public String getAsString(@Nonnull Charset charset) throws IOException {
        return new String(this.getAsBytes(), charset);
    }

    public abstract int getContentLength();

    protected abstract byte[] compute() throws IOException;
}

