/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.content.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.model.ContentType;
import net.lenni0451.commons.httpclient.utils.HttpRequestUtils;

public class FileContent
extends HttpContent {
    private final File file;

    public FileContent(@Nonnull File file) {
        this(ContentTypes.APPLICATION_OCTET_STREAM, file);
    }

    public FileContent(@Nonnull ContentType contentType, @Nonnull File file) {
        super(contentType);
        this.file = file;
    }

    @Override
    public int getContentLength() {
        return (int)this.file.length();
    }

    @Override
    protected byte[] compute() throws IOException {
        try (FileInputStream fis = new FileInputStream(this.file);){
            byte[] byArray = HttpRequestUtils.readFromStream(fis);
            return byArray;
        }
    }
}

