/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.requests;

import java.net.CookieManager;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.commons.httpclient.HeaderStore;
import net.lenni0451.commons.httpclient.RetryHandler;

public class HttpRequest
extends HeaderStore<HttpRequest> {
    private final String method;
    private final URL url;
    private FollowRedirects followRedirects = FollowRedirects.NOT_SET;
    private CookieManager cookieManager;
    private boolean cookieManagerSet = false;
    private RetryHandler retryHandler = new RetryHandler();
    private boolean retryHandlerSet = false;

    public HttpRequest(@Nonnull String method, @Nonnull String url) throws MalformedURLException {
        this(method, new URL(url));
    }

    public HttpRequest(@Nonnull String method, @Nonnull URL url) {
        this.method = method;
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public URL getURL() {
        return this.url;
    }

    public FollowRedirects getFollowRedirects() {
        return this.followRedirects;
    }

    public HttpRequest setFollowRedirects(boolean followRedirects) {
        return this.setFollowRedirects(followRedirects ? FollowRedirects.FOLLOW : FollowRedirects.IGNORE);
    }

    public HttpRequest setFollowRedirects(@Nonnull FollowRedirects followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public boolean isCookieManagerSet() {
        return this.cookieManagerSet;
    }

    public HttpRequest unsetCookieManager() {
        this.cookieManager = null;
        this.cookieManagerSet = false;
        return this;
    }

    @Nullable
    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public HttpRequest setCookieManager(@Nullable CookieManager cookieManager) {
        this.cookieManager = cookieManager;
        this.cookieManagerSet = true;
        return this;
    }

    public boolean isRetryHandlerSet() {
        return this.retryHandlerSet;
    }

    public HttpRequest unsetRetryHandler() {
        this.retryHandler = new RetryHandler();
        this.retryHandlerSet = false;
        return this;
    }

    public RetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public HttpRequest setRetryHandler(@Nonnull RetryHandler retryHandler) {
        this.retryHandler = retryHandler;
        this.retryHandlerSet = true;
        return this;
    }

    public static enum FollowRedirects {
        NOT_SET,
        FOLLOW,
        IGNORE;

    }
}

