/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.imaging;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageHelpers$
implements ScalaObject {
    public static final ImageHelpers$ MODULE$;
    private final RenderingHints highQualityHints;
    private volatile int bitmap$init$0;

    static {
        new ImageHelpers$();
    }

    public RenderingHints highQualityHints() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.highQualityHints;
        }
        throw new UninitializedFieldError("Uninitialized field: ImageHelpers.scala: 34".toString());
    }

    public Tuple2<BufferedImage, String> resize(BufferedImage source, String inputFormat, double dx$1, double dy$1) {
        ColorModel sourceColorModel = source.getColorModel();
        ColorModel targetColorModel = source.getColorModel();
        ColorModel standardColorModel = ColorModel.getRGBdefault();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp((int)((double)source.getWidth() * dx$1), (int)((double)source.getHeight() * dy$1));
        if (sp2 != null) {
            Tuple2 tuple2;
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)sp2._1()), BoxesRunTime.unboxToInt((Object)sp2._2()));
            int targetWidth = sp3._1$mcI$sp();
            int targetHeight = sp3._2$mcI$sp();
            if (sourceColorModel instanceof IndexColorModel && sourceColorModel.hasAlpha() && sourceColorModel.getTransparency() == 2 && ((IndexColorModel)sourceColorModel).getTransparentPixel() >= 0) {
                IndexColorModel indexColorModel = (IndexColorModel)sourceColorModel;
                int transparent = indexColorModel.getRGB(indexColorModel.getTransparentPixel());
                BufferedImage masked = new BufferedImage(standardColorModel, standardColorModel.createCompatibleWritableRaster(source.getWidth(), source.getHeight()), standardColorModel.isAlphaPremultiplied(), null);
                int w = masked.getWidth();
                int h = masked.getHeight();
                int[] buf = new int[w];
                for (int y = 0; y < h; ++y) {
                    source.getRGB(0, y, w, 1, buf, 0, 1);
                    for (int x = 0; x < w; ++x) {
                        int c = buf[x];
                        if (c != transparent) continue;
                        buf[x] = 0;
                    }
                    masked.setRGB(0, y, w, 1, buf, 0, 1);
                }
                BufferedImage resized = new BufferedImage(standardColorModel, standardColorModel.createCompatibleWritableRaster(targetWidth, targetHeight), standardColorModel.isAlphaPremultiplied(), null);
                this.resize$1(masked, resized, dx$1, dy$1);
                tuple2 = new Tuple2((Object)resized, (Object)"png");
            } else if (sourceColorModel instanceof IndexColorModel) {
                BufferedImage resized = new BufferedImage(standardColorModel, standardColorModel.createCompatibleWritableRaster(targetWidth, targetHeight), standardColorModel.isAlphaPremultiplied(), null);
                this.resize$1(source, resized, dx$1, dy$1);
                tuple2 = new Tuple2((Object)resized, (Object)"png");
            } else {
                BufferedImage resized = new BufferedImage(targetColorModel, targetColorModel.createCompatibleWritableRaster(targetWidth, targetHeight), targetColorModel.isAlphaPremultiplied(), null);
                this.resize$1(source, resized, dx$1, dy$1);
                tuple2 = new Tuple2((Object)resized, (Object)inputFormat);
            }
            return tuple2;
        }
        throw new MatchError((Object)sp2);
    }

    private final void resize$1(BufferedImage src, BufferedImage dst, double d, double d2) {
        Graphics2D g = dst.createGraphics();
        try {
            g.setRenderingHints(this.highQualityHints());
            g.drawImage(src, new AffineTransformOp(AffineTransform.getScaleInstance(d, d2), 3), 0, 0);
            return;
        }
        finally {
            g.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private ImageHelpers$() {
        void var1_1;
        MODULE$ = this;
        RenderingHints h = new RenderingHints(null);
        h.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        h.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        h.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        h.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        h.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.highQualityHints = var1_1;
        this.bitmap$init$0 |= 1;
    }
}

