/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.json;

import java.io.Serializable;
import net.liftweb.json.JsonAST;
import net.liftweb.json.JsonAST$JNothing$;
import net.liftweb.json.JsonAST$JNull$;
import net.liftweb.json.JsonAST$RenderSettings$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

public final class JsonAST$ {
    public static final JsonAST$ MODULE$ = new JsonAST$();

    public JsonAST.JValue concat(Seq<JsonAST.JValue> values) {
        return (JsonAST.JValue)values.foldLeft((Object)JsonAST$JNothing$.MODULE$, (Function2 & Serializable)(x$1, x$2) -> x$1.$plus$plus((JsonAST.JValue)x$2));
    }

    public String quote(String s) {
        StringBuilder buf = new StringBuilder();
        this.appendEscapedString(buf, s, JsonAST$RenderSettings$.MODULE$.compact());
        return buf.toString();
    }

    private void appendEscapedString(Appendable buf, String s, JsonAST.RenderSettings settings) {
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)c -> JsonAST$.$anonfun$appendEscapedString$1(settings, buf, BoxesRunTime.unboxToChar((Object)c)));
    }

    public String prettyRender(JsonAST.JValue value) {
        return this.render(value, JsonAST$RenderSettings$.MODULE$.pretty(), this.render$default$3());
    }

    public String prettyRender(JsonAST.JValue value, Appendable appendable) {
        return this.render(value, JsonAST$RenderSettings$.MODULE$.pretty(), appendable);
    }

    public String compactRender(JsonAST.JValue value) {
        return this.render(value, JsonAST$RenderSettings$.MODULE$.compact(), this.render$default$3());
    }

    public String compactRender(JsonAST.JValue value, Appendable appendable) {
        return this.render(value, JsonAST$RenderSettings$.MODULE$.compact(), appendable);
    }

    public String render(JsonAST.JValue value, JsonAST.RenderSettings settings, Appendable appendable) {
        return this.bufRender(value, appendable, settings, this.bufRender$default$4()).toString();
    }

    public JsonAST.RenderIntermediaryDocument render(JsonAST.JValue value) {
        return new JsonAST.RenderIntermediaryDocument(value);
    }

    public Appendable render$default$3() {
        return new StringBuilder();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Appendable bufRender(JsonAST.JValue value, Appendable buf, JsonAST.RenderSettings settings, int indentLevel) {
        boolean bl;
        boolean bl2 = false;
        JsonAST.JBool jBool = null;
        boolean bl3 = false;
        JsonAST.JString jString = null;
        JsonAST.JValue jValue = value;
        if (jValue == null) {
            return buf.append("null");
        }
        if (jValue instanceof JsonAST.JBool) {
            bl2 = true;
            jBool = (JsonAST.JBool)jValue;
            boolean bl4 = jBool.value();
            if (bl4) {
                return buf.append("true");
            }
        }
        if (bl2 && !(bl = jBool.value())) {
            return buf.append("false");
        }
        if (jValue instanceof JsonAST.JDouble) {
            JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
            double n = jDouble.num();
            return buf.append(settings.doubleRenderer().apply(n));
        }
        if (jValue instanceof JsonAST.JInt) {
            JsonAST.JInt jInt = (JsonAST.JInt)jValue;
            BigInt n = jInt.num();
            return buf.append(n.toString());
        }
        if (JsonAST$JNull$.MODULE$.equals(jValue)) {
            return buf.append("null");
        }
        if (jValue instanceof JsonAST.JString) {
            bl3 = true;
            jString = (JsonAST.JString)jValue;
            String string = jString.s();
            if (string == null) {
                return buf.append("null");
            }
        }
        if (bl3) {
            String s = jString.s();
            return this.bufQuote(s, buf, settings);
        }
        if (jValue instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)jValue;
            List<JsonAST.JValue> arr = jArray.arr();
            return this.bufRenderArr(arr, buf, settings, indentLevel);
        }
        if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            List<JsonAST.JField> obj = jObject.obj();
            return this.bufRenderObj(obj, buf, settings, indentLevel);
        }
        if (!JsonAST$JNothing$.MODULE$.equals(jValue)) throw new MatchError((Object)jValue);
        throw package$.MODULE$.error("can't render 'nothing'");
    }

    private int bufRender$default$4() {
        return 0;
    }

    private Appendable bufRenderArr(List<JsonAST.JValue> values, Appendable buf, JsonAST.RenderSettings settings, int indentLevel) {
        BooleanRef firstEntry = BooleanRef.create((boolean)true);
        int currentIndent = indentLevel + settings.indent();
        buf.append('[');
        if (!values.isEmpty()) {
            Object object = settings.lineBreaks_$qmark() ? buf.append('\n') : BoxedUnit.UNIT;
            values.foreach((Function1 & Serializable)elem -> {
                Object object;
                JsonAST.JValue jValue = elem;
                JsonAST$JNothing$ jsonAST$JNothing$ = JsonAST$JNothing$.MODULE$;
                if (jValue == null ? jsonAST$JNothing$ != null : !jValue.equals(jsonAST$JNothing$)) {
                    Object object2;
                    if (firstEntry$1.elem) {
                        firstEntry$1.elem = false;
                        object2 = BoxedUnit.UNIT;
                    } else {
                        buf.append(',');
                        object2 = settings.lineBreaks_$qmark() ? buf.append('\n') : BoxedUnit.UNIT;
                    }
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), currentIndent).foreach((Function1 & Serializable)x$8 -> buf.append(' '));
                    object = MODULE$.bufRender((JsonAST.JValue)elem, buf, settings, currentIndent);
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            Object object2 = settings.lineBreaks_$qmark() ? buf.append('\n') : BoxedUnit.UNIT;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), indentLevel).foreach((Function1 & Serializable)x$9 -> buf.append(' '));
        }
        buf.append(']');
        return buf;
    }

    private Appendable bufRenderObj(List<JsonAST.JField> fields, Appendable buf, JsonAST.RenderSettings settings, int indentLevel) {
        BooleanRef firstEntry = BooleanRef.create((boolean)true);
        int currentIndent = indentLevel + settings.indent();
        buf.append('{');
        if (!fields.isEmpty()) {
            Object object = settings.lineBreaks_$qmark() ? buf.append('\n') : BoxedUnit.UNIT;
            fields.foreach((Function1 & Serializable)x0$1 -> {
                void var5_11;
                JsonAST.JField jField = x0$1;
                if (jField != null) {
                    JsonAST.JValue value;
                    String name = jField.name();
                    JsonAST.JValue jValue = value = jField.value();
                    JsonAST$JNothing$ jsonAST$JNothing$ = JsonAST$JNothing$.MODULE$;
                    if (jValue == null ? jsonAST$JNothing$ != null : !jValue.equals(jsonAST$JNothing$)) {
                        Object object;
                        if (firstEntry$2.elem) {
                            firstEntry$2.elem = false;
                            object = BoxedUnit.UNIT;
                        } else {
                            buf.append(',');
                            object = settings.lineBreaks_$qmark() ? buf.append('\n') : BoxedUnit.UNIT;
                        }
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), currentIndent).foreach((Function1 & Serializable)x$10 -> buf.append(' '));
                        MODULE$.bufQuote(name, buf, settings);
                        buf.append(':');
                        Object object2 = settings.spaceAfterFieldName() ? buf.append(' ') : BoxedUnit.UNIT;
                        Appendable appendable = MODULE$.bufRender(value, buf, settings, currentIndent);
                        return var5_11;
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return var5_11;
            });
            Object object2 = settings.lineBreaks_$qmark() ? buf.append('\n') : BoxedUnit.UNIT;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), indentLevel).foreach((Function1 & Serializable)x$11 -> buf.append(' '));
        }
        buf.append('}');
        return buf;
    }

    private Appendable bufQuote(String s, Appendable buf, JsonAST.RenderSettings settings) {
        buf.append('\"');
        this.appendEscapedString(buf, s, settings);
        buf.append('\"');
        return buf;
    }

    public static final /* synthetic */ Appendable $anonfun$appendEscapedString$1(JsonAST.RenderSettings settings$1, Appendable buf$1, char c) {
        String string;
        char c2 = c;
        switch (c2) {
            case '\"': {
                string = "\\\"";
                break;
            }
            case '\\': {
                string = "\\\\";
                break;
            }
            case '\b': {
                string = "\\b";
                break;
            }
            case '\f': {
                string = "\\f";
                break;
            }
            case '\n': {
                string = "\\n";
                break;
            }
            case '\r': {
                string = "\\r";
                break;
            }
            case '\t': {
                string = "\\t";
                break;
            }
            default: {
                if (c2 >= '\u0000' && c2 < ' ' || settings$1.escapeChars().nonEmpty() && settings$1.escapeChars().contains((Object)BoxesRunTime.boxToCharacter((char)c2))) {
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c2)}));
                    break;
                }
                string = "";
                break;
            }
        }
        String strReplacement = string;
        return strReplacement.isEmpty() ? buf$1.append(c) : buf$1.append(strReplacement);
    }

    private JsonAST$() {
    }
}

