/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.transaction;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRequiredException;
import net.liftweb.common.Logger$;
import net.liftweb.transaction.EntityManagerSynchronization;
import net.liftweb.transaction.TransactionContext$;
import net.liftweb.transaction.TransactionProtocol;
import net.liftweb.transaction.TransactionProtocol$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public abstract class TransactionProtocol$class {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object withTxRequired(TransactionProtocol $this, Function0 body) {
        Object object;
        TransactionManager tm = TransactionContext$.MODULE$.getTransactionManager();
        if ($this.isInExistingTransaction(tm)) {
            object = body.apply();
            return object;
        }
        tm.begin();
        try {
            TransactionProtocol$class.net$liftweb$transaction$TransactionProtocol$$joinTransaction($this);
            Object exceptionResult1 = body.apply();
            object = exceptionResult1;
            return object;
        }
        catch (Exception exception) {
            throw $this.handleException(tm, exception);
        }
        finally {
            $this.commitOrRollBack(tm);
        }
    }

    public static Object withTxRequiresNew(TransactionProtocol $this, Function0 body$1) {
        return TransactionContext$.MODULE$.withNewContext(new Serializable($this, body$1){
            public static final long serialVersionUID;
            private final TransactionProtocol $outer;
            private final Function0 body$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final T apply() {
                TransactionManager tm = TransactionContext$.MODULE$.getTransactionManager();
                tm.begin();
                try {
                    TransactionProtocol$class.net$liftweb$transaction$TransactionProtocol$$joinTransaction(this.$outer);
                    Object exceptionResult2 = this.body$1.apply();
                    return (T)exceptionResult2;
                }
                catch (Exception exception) {
                    throw this.$outer.handleException(tm, exception);
                }
                finally {
                    this.$outer.commitOrRollBack(tm);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.body$1 = function0;
            }
        });
    }

    public static Object withTxNotSupported(TransactionProtocol $this, Function0 body) {
        return TransactionContext$.MODULE$.withNewContext(body);
    }

    public static Object withTxSupports(TransactionProtocol $this, Function0 body) {
        return body.apply();
    }

    public static Object withTxMandatory(TransactionProtocol $this, Function0 body) {
        if ($this.isInExistingTransaction(TransactionContext$.MODULE$.getTransactionManager())) {
            return body.apply();
        }
        throw new TransactionRequiredException("No active TX at method with TX type set to MANDATORY");
    }

    public static Object withTxNever(TransactionProtocol $this, Function0 body) {
        if ($this.isInExistingTransaction(TransactionContext$.MODULE$.getTransactionManager())) {
            throw new SystemException("Detected active TX at method with TX type set to NEVER");
        }
        return body.apply();
    }

    public static Nothing$ handleException(TransactionProtocol $this, TransactionManager tm, Exception e$1) {
        if ($this.isInExistingTransaction(tm) && !(e$1 instanceof NoResultException) && !(e$1 instanceof NonUniqueResultException)) {
            $this.net$liftweb$transaction$TransactionProtocol$$logger().debug((Function0)new Serializable($this, e$1){
                public static final long serialVersionUID;
                public final Exception e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Setting TX to ROLLBACK_ONLY, due to: ").append((Object)this.e$1).toString();
                }
                {
                    this.e$1 = exception;
                }
            });
            tm.setRollbackOnly();
        }
        throw e$1;
    }

    public static void commitOrRollBack(TransactionProtocol $this, TransactionManager tm) {
        if ($this.isInExistingTransaction(tm)) {
            if ($this.isRollbackOnly(tm)) {
                $this.net$liftweb$transaction$TransactionProtocol$$logger().debug((Function0)new Serializable($this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Rolling back TX marked as ROLLBACK_ONLY";
                    }
                });
                tm.rollback();
            } else {
                $this.net$liftweb$transaction$TransactionProtocol$$logger().debug((Function0)new Serializable($this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Committing TX";
                    }
                });
                tm.commit();
            }
        }
    }

    public static boolean isInExistingTransaction(TransactionProtocol $this, TransactionManager tm) {
        return tm.getStatus() != 6;
    }

    public static boolean isRollbackOnly(TransactionProtocol $this, TransactionManager tm) {
        return tm.getStatus() == 1;
    }

    public static final void net$liftweb$transaction$TransactionProtocol$$joinTransaction(TransactionProtocol $this) {
        EntityManager em = TransactionContext$.MODULE$.getEntityManager();
        TransactionManager tm = TransactionContext$.MODULE$.getTransactionManager();
        tm.getTransaction().registerSynchronization((Synchronization)new EntityManagerSynchronization(em, tm, false));
        em.joinTransaction();
    }

    private static void storeInThreadLocal(TransactionProtocol $this, Transaction tx) {
        $this.net$liftweb$transaction$TransactionProtocol$$suspendedTx().set(tx);
    }

    private static Option fetchFromThreadLocal(TransactionProtocol $this) {
        return $this.net$liftweb$transaction$TransactionProtocol$$suspendedTx() == null || $this.net$liftweb$transaction$TransactionProtocol$$suspendedTx().get() == null ? None$.MODULE$ : new Some((Object)$this.net$liftweb$transaction$TransactionProtocol$$suspendedTx().get());
    }

    public static void $init$(TransactionProtocol $this) {
        $this.net$liftweb$transaction$TransactionProtocol$_setter_$net$liftweb$transaction$TransactionProtocol$$logger_$eq(Logger$.MODULE$.apply(TransactionProtocol.class));
        $this.net$liftweb$transaction$TransactionProtocol$_setter_$net$liftweb$transaction$TransactionProtocol$$suspendedTx_$eq(new TransactionProtocol$.anon.1($this));
    }
}

