/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import java.rmi.RemoteException;
import net.liftweb.util.CurrencyMismatchException;
import net.liftweb.util.Helpers$;
import scala.Math$;
import scala.Predef$;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.runtime.BoxesRunTime;

public class Currency
implements ScalaObject {
    private final int decimals;
    private final String symbol;
    private final long amount;

    public Currency(long amount, String symbol, int decimals) {
        this.amount = amount;
        this.symbol = symbol;
        this.decimals = decimals;
    }

    public Currency $minus(Currency other) {
        String string2 = this.symbol();
        String string3 = other.symbol();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.decimals() == other.decimals()) {
            return new Currency(this.amount() - other.amount(), this.symbol(), this.decimals());
        }
        throw new CurrencyMismatchException();
    }

    public Currency $plus(Currency other) {
        String string2 = this.symbol();
        String string3 = other.symbol();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.decimals() == other.decimals()) {
            return new Currency(this.amount() + other.amount(), this.symbol(), this.decimals());
        }
        throw new CurrencyMismatchException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof Currency)) return false;
        Currency currency = (Currency)object;
        Currency c = currency;
        if (c.amount() != this.amount()) return false;
        String string2 = c.symbol();
        String string3 = this.symbol();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        if (c.decimals() != this.decimals()) return false;
        return true;
    }

    public String forDB() {
        return new StringBuilder().append((Object)Helpers$.MODULE$.urlEncode(this.symbol())).append((Object)"&").append((Object)BoxesRunTime.boxToLong((long)this.amount())).append((Object)"&").append((Object)BoxesRunTime.boxToInteger((int)this.decimals())).toString();
    }

    public String toString() {
        String string2;
        if (this.decimals() == 0) {
            string2 = new StringBuilder().append((Object)this.symbol()).append((Object)BoxesRunTime.boxToLong((long)this.amount())).toString();
        } else {
            double d = this.amount();
            double pow = Math$.MODULE$.pow(10.0, Predef$.MODULE$.int2double(this.decimals()));
            string2 = new StringBuilder().append((Object)this.symbol()).append((Object)BoxesRunTime.boxToDouble((double)(d / pow))).toString();
        }
        return string2;
    }

    public int decimals() {
        return this.decimals;
    }

    public String symbol() {
        return this.symbol;
    }

    public long amount() {
        return this.amount;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

