/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import net.liftweb.common.Box;
import net.liftweb.util.Currency$;
import net.liftweb.util.CurrencyMismatchException;
import net.liftweb.util.Helpers$;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005%4A!\u0005\n\u00013!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003#\u0011!1\u0003A!b\u0001\n\u00039\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u0011Q\u0002!Q1A\u0005\u0002UB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\u0006\u0003\u0002!\tE\u0011\u0005\u0006\u0015\u0002!\ta\n\u0005\u0006\u0017\u0002!\t\u0005\u0014\u0005\u0006+\u0002!\tA\u0016\u0005\u00061\u0002!\t!W\u0004\u00067JA\t\u0001\u0018\u0004\u0006#IA\t!\u0018\u0005\u0006u9!\tA\u0018\u0005\u0006?:!\t\u0001\u0019\u0002\t\u0007V\u0014(/\u001a8ds*\u00111\u0003F\u0001\u0005kRLGN\u0003\u0002\u0016-\u00059A.\u001b4uo\u0016\u0014'\"A\f\u0002\u00079,Go\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004b[>,h\u000e^\u000b\u0002EA\u00111dI\u0005\u0003Iq\u0011A\u0001T8oO\u00069\u0011-\\8v]R\u0004\u0013AB:z[\n|G.F\u0001)!\tI\u0003G\u0004\u0002+]A\u00111\u0006H\u0007\u0002Y)\u0011Q\u0006G\u0001\u0007yI|w\u000e\u001e \n\u0005=b\u0012A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\u000f\u0002\u000fMLXNY8mA\u0005AA-Z2j[\u0006d7/F\u00017!\tYr'\u0003\u000299\t\u0019\u0011J\u001c;\u0002\u0013\u0011,7-[7bYN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003=}}\u0002\u0005CA\u001f\u0001\u001b\u0005\u0011\u0002\"\u0002\u0011\b\u0001\u0004\u0011\u0003\"\u0002\u0014\b\u0001\u0004A\u0003\"\u0002\u001b\b\u0001\u00041\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\t1\fgn\u001a\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\t\tT)A\u0003g_J$%)\u0001\u0004fcV\fGn\u001d\u000b\u0003\u001bB\u0003\"a\u0007(\n\u0005=c\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006#*\u0001\rAU\u0001\u0006_RDWM\u001d\t\u00037MK!\u0001\u0016\u000f\u0003\u0007\u0005s\u00170A\u0003%a2,8\u000f\u0006\u0002=/\")\u0011k\u0003a\u0001y\u00051A%\\5okN$\"\u0001\u0010.\t\u000bEc\u0001\u0019\u0001\u001f\u0002\u0011\r+(O]3oGf\u0004\"!\u0010\b\u0014\u00059QB#\u0001/\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005\u0005<\u0007c\u00012fy5\t1M\u0003\u0002e)\u000511m\\7n_:L!AZ2\u0003\u0007\t{\u0007\u0010C\u0003i!\u0001\u0007\u0001&A\u0001t\u0001")
public class Currency {
    private final long amount;
    private final String symbol;
    private final int decimals;

    public static Box<Currency> apply(String string) {
        return Currency$.MODULE$.apply(string);
    }

    public long amount() {
        return this.amount;
    }

    public String symbol() {
        return this.symbol;
    }

    public int decimals() {
        return this.decimals;
    }

    public String toString() {
        String string;
        if (this.decimals() == 0) {
            string = new StringBuilder(0).append(this.symbol()).append(this.amount()).toString();
        } else {
            double d = this.amount();
            double pow = package$.MODULE$.pow(10.0, (double)this.decimals());
            string = new StringBuilder(0).append(this.symbol()).append(d / pow).toString();
        }
        return string;
    }

    public String forDB() {
        return new StringBuilder(2).append(Helpers$.MODULE$.urlEncode(this.symbol())).append("&").append(this.amount()).append("&").append(this.decimals()).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof Currency)) return false;
        Currency currency = (Currency)object;
        if (currency.amount() != this.amount()) return false;
        String string = currency.symbol();
        String string2 = this.symbol();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (currency.decimals() != this.decimals()) return false;
        return true;
    }

    public Currency $plus(Currency other) {
        String string = this.symbol();
        String string2 = other.symbol();
        if ((string != null ? !string.equals(string2) : string2 != null) || this.decimals() != other.decimals()) {
            throw new CurrencyMismatchException();
        }
        return new Currency(this.amount() + other.amount(), this.symbol(), this.decimals());
    }

    public Currency $minus(Currency other) {
        String string = this.symbol();
        String string2 = other.symbol();
        if ((string != null ? !string.equals(string2) : string2 != null) || this.decimals() != other.decimals()) {
            throw new CurrencyMismatchException();
        }
        return new Currency(this.amount() - other.amount(), this.symbol(), this.decimals());
    }

    public Currency(long amount, String symbol, int decimals) {
        this.amount = amount;
        this.symbol = symbol;
        this.decimals = decimals;
    }
}

