/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.liftweb.common.Box;
import net.liftweb.util.Helpers$;
import net.liftweb.util.IoHelpers;
import net.liftweb.util.SecurityHelpers;
import net.liftweb.util.SecurityHelpers$;
import org.apache.commons.codec.binary.Base64;
import scala.Function1;
import scala.Math$;
import scala.Predef$;
import scala.StringBuilder;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedByteArray;
import scala.runtime.ScalaRunTime$;
import scala.xml.Node;

public abstract class SecurityHelpers$class {
    public static void $init$(SecurityHelpers $this) {
        $this.net$liftweb$util$SecurityHelpers$$random_$eq(new SecureRandom());
    }

    private static final void addDigit$1(SecurityHelpers $this, byte[] in, int pos, int len, StringBuilder sb) {
        while (pos < len) {
            int b = Predef$.MODULE$.byte2int(in[pos]);
            int msb = (b & 0xF0) >> 4;
            int lsb = b & 0xF;
            sb.append(msb < 10 ? (char)(48 + msb) : (char)(97 + (msb - 10)));
            sb.append(lsb < 10 ? (char)(48 + lsb) : (char)(97 + (lsb - 10)));
            ++pos;
        }
    }

    private static final int byteOf$1(SecurityHelpers $this, char in) {
        int n;
        char c = in;
        switch (c) {
            default: {
                n = 0;
                break;
            }
            case 'f': {
                n = 15;
                break;
            }
            case 'e': {
                n = 14;
                break;
            }
            case 'd': {
                n = 13;
                break;
            }
            case 'c': {
                n = 12;
                break;
            }
            case 'b': {
                n = 11;
                break;
            }
            case 'a': {
                n = 10;
                break;
            }
            case 'F': {
                n = 15;
                break;
            }
            case 'E': {
                n = 14;
                break;
            }
            case 'D': {
                n = 13;
                break;
            }
            case 'C': {
                n = 12;
                break;
            }
            case 'B': {
                n = 11;
                break;
            }
            case 'A': {
                n = 10;
                break;
            }
            case '9': {
                n = 9;
                break;
            }
            case '8': {
                n = 8;
                break;
            }
            case '7': {
                n = 7;
                break;
            }
            case '6': {
                n = 6;
                break;
            }
            case '5': {
                n = 5;
                break;
            }
            case '4': {
                n = 4;
                break;
            }
            case '3': {
                n = 3;
                break;
            }
            case '2': {
                n = 2;
                break;
            }
            case '1': {
                n = 1;
                break;
            }
            case '0': {
                n = 0;
            }
        }
        return n;
    }

    public static String hexEncode(SecurityHelpers $this, byte[] in) {
        StringBuilder sb = new StringBuilder();
        int len = in.length;
        SecurityHelpers$class.addDigit$1($this, in, 0, len, sb);
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] hexDecode(SecurityHelpers $this, String str) {
        void var3_3;
        int max2 = str.length() / 2;
        byte[] ret = new byte[max2];
        for (int pos = 0; pos < max2; ++pos) {
            int two = pos * 2;
            char ch = str.charAt(two);
            char cl = str.charAt(two + 1);
            ret[pos] = (byte)(SecurityHelpers$class.byteOf$1($this, ch) * 16 + SecurityHelpers$class.byteOf$1($this, cl));
        }
        return var3_3;
    }

    public static String hexDigest256(SecurityHelpers $this, byte[] in) {
        byte[] binHash = MessageDigest.getInstance("SHA-256").digest(in);
        return $this.hexEncode(binHash);
    }

    public static String hexDigest(SecurityHelpers $this, byte[] in) {
        byte[] binHash = MessageDigest.getInstance("SHA").digest(in);
        return $this.hexEncode(binHash);
    }

    public static String hash256(SecurityHelpers $this, String in) {
        return new String(SecurityHelpers$class.cleanArray($this, new Base64().encode(MessageDigest.getInstance("SHA-256").digest(in.getBytes("UTF-8")))));
    }

    public static byte[] hash256(SecurityHelpers $this, byte[] in) {
        return MessageDigest.getInstance("SHA-256").digest(in);
    }

    public static boolean secureEquals(SecurityHelpers $this, byte[] s1, byte[] s2) {
        boolean bl;
        byte[] byArray = s1;
        byte[] byArray2 = s2;
        if (byArray == null) {
            bl = byArray2 == null;
        } else if (byArray2 == null) {
            bl = false;
        } else {
            byte[] a = byArray;
            byte[] b = byArray2;
            int la = a.length;
            int lb = b.length;
            boolean ret = true;
            for (int pos = 0; pos < la && pos < lb; ++pos) {
                ret &= a[pos] == b[pos];
            }
            bl = ret && la == lb;
        }
        return bl;
    }

    public static boolean secureEquals(SecurityHelpers $this, String s1, String s2) {
        String string2 = s1;
        String string3 = s2;
        return string2 == null ? string3 == null : (string3 == null ? false : $this.secureEquals(string2.getBytes("UTF-8"), string3.getBytes("UTF-8")));
    }

    public static String hashHex(SecurityHelpers $this, String in) {
        return Helpers$.MODULE$.hexEncode(MessageDigest.getInstance("SHA").digest(in.getBytes("UTF-8")));
    }

    public static String hash(SecurityHelpers $this, String in) {
        return new String(SecurityHelpers$class.cleanArray($this, new Base64().encode(MessageDigest.getInstance("SHA").digest(in.getBytes("UTF-8")))));
    }

    public static byte[] hash(SecurityHelpers $this, byte[] in) {
        return MessageDigest.getInstance("SHA").digest(in);
    }

    public static String md5(SecurityHelpers $this, String in) {
        return new String(SecurityHelpers$class.cleanArray($this, new Base64().encode($this.md5(in.getBytes("UTF-8")))));
    }

    public static byte[] md5(SecurityHelpers $this, byte[] in) {
        return MessageDigest.getInstance("MD5").digest(in);
    }

    public static byte[] base64Decode(SecurityHelpers $this, String in) {
        return new Base64().decode(in.getBytes("UTF-8"));
    }

    public static String base64EncodeURLSafe(SecurityHelpers $this, byte[] in) {
        return new String(Base64.encodeBase64URLSafe((byte[])in));
    }

    public static String base64Encode(SecurityHelpers $this, byte[] in) {
        return new String(SecurityHelpers$class.cleanArray($this, new Base64().encode(in)));
    }

    private static final byte[] cleanArray(SecurityHelpers $this, byte[] in) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(new BoxedByteArray(in).filter((Function1)new SecurityHelpers$.anonfun.cleanArray.1($this)), Byte.TYPE);
        return (byte[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Byte.TYPE) : object);
    }

    public static InputStream tripleDESEncryptStream(SecurityHelpers $this, InputStream in, SecretKey key2) {
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        cipher.init(1, (Key)key2, new IvParameterSpec(new byte[8]));
        return new CipherInputStream(in, cipher);
    }

    public static InputStream tripleDESEncryptStream(SecurityHelpers $this, InputStream in, byte[] key2) {
        return $this.tripleDESEncryptStream(in, $this.tripleDESKeyFromBytes(key2));
    }

    public static InputStream encryptStream(SecurityHelpers $this, InputStream in, SecretKey key2) {
        Cipher cipher = Cipher.getInstance("blowfish");
        cipher.init(1, key2);
        return new CipherInputStream(in, cipher);
    }

    public static InputStream encryptStream(SecurityHelpers $this, InputStream in, byte[] key2) {
        return $this.encryptStream(in, $this.blowfishKeyFromBytes(key2));
    }

    public static Box decryptXML(SecurityHelpers $this, String in$1, SecretKey key$1) {
        return Helpers$.MODULE$.tryo(new SecurityHelpers$.anonfun.decryptXML.1($this, in$1, key$1)).flatMap((Function1)new SecurityHelpers$.anonfun.decryptXML.2($this));
    }

    public static Box decryptXML(SecurityHelpers $this, String in, byte[] key2) {
        return $this.decryptXML(in, $this.blowfishKeyFromBytes(key2));
    }

    public static String encryptXML(SecurityHelpers $this, Node in, SecretKey key2) {
        return $this.blowfishEncrypt(in.toString(), key2);
    }

    public static String encryptXML(SecurityHelpers $this, Node in, byte[] key2) {
        return $this.encryptXML(in, $this.blowfishKeyFromBytes(key2));
    }

    public static InputStream tripleDESDecryptStream(SecurityHelpers $this, InputStream in, SecretKey key2) {
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        cipher.init(2, (Key)key2, new IvParameterSpec(new byte[8]));
        return new CipherInputStream(in, cipher);
    }

    public static InputStream tripleDESDDecryptStream(SecurityHelpers $this, InputStream in, byte[] key2) {
        return $this.tripleDESDecryptStream(in, $this.tripleDESKeyFromBytes(key2));
    }

    public static InputStream decryptStream(SecurityHelpers $this, InputStream in, SecretKey key2) {
        Cipher cipher = Cipher.getInstance("blowfish");
        cipher.init(2, key2);
        return new CipherInputStream(in, cipher);
    }

    public static InputStream decryptStream(SecurityHelpers $this, InputStream in, byte[] key2) {
        return $this.decryptStream(in, $this.blowfishKeyFromBytes(key2));
    }

    public static String tripleDESEncrypt(SecurityHelpers $this, String plain, SecretKey key2) {
        return $this.base64Encode($this.tripleDESEncrypt(plain.getBytes("UTF-8"), key2));
    }

    public static String tripleDESEncrypt(SecurityHelpers $this, String plain, byte[] key2) {
        return $this.tripleDESEncrypt(plain, $this.tripleDESKeyFromBytes(key2));
    }

    public static byte[] tripleDESEncrypt(SecurityHelpers $this, byte[] plain, SecretKey key2) {
        return ((IoHelpers)((Object)$this)).readWholeStream($this.tripleDESEncryptStream((InputStream)new ByteArrayInputStream(plain), key2));
    }

    public static byte[] tripleDESEncrypt(SecurityHelpers $this, byte[] plain, byte[] key2) {
        return $this.tripleDESEncrypt(plain, $this.tripleDESKeyFromBytes(key2));
    }

    public static String tripleDESDecrypt(SecurityHelpers $this, String enc, SecretKey key2) {
        return new String($this.tripleDESDecrypt($this.base64Decode(enc), key2), "UTF-8");
    }

    public static String tripleDESDecrypt(SecurityHelpers $this, String enc, byte[] key2) {
        return $this.tripleDESDecrypt(enc, $this.tripleDESKeyFromBytes(key2));
    }

    public static byte[] tripleDESDecrypt(SecurityHelpers $this, byte[] enc, SecretKey key2) {
        return ((IoHelpers)((Object)$this)).readWholeStream($this.tripleDESDecryptStream(new ByteArrayInputStream(enc), key2));
    }

    public static byte[] tripleDESDecrypt(SecurityHelpers $this, byte[] enc, byte[] key2) {
        return $this.tripleDESDecrypt(enc, $this.tripleDESKeyFromBytes(key2));
    }

    public static SecretKey tripleDESKeyFromBytes(SecurityHelpers $this, byte[] key2) {
        return new SecretKeySpec(key2, "DESede");
    }

    public static byte[] makeTripleDESKey(SecurityHelpers $this) {
        return KeyGenerator.getInstance("DESede").generateKey().getEncoded();
    }

    public static String blowfishEncrypt(SecurityHelpers $this, String plain, SecretKey key2) {
        return $this.base64Encode($this.blowfishEncrypt(plain.getBytes("UTF-8"), key2));
    }

    public static String blowfishEncrypt(SecurityHelpers $this, String plain, byte[] key2) {
        return $this.blowfishEncrypt(plain, $this.blowfishKeyFromBytes(key2));
    }

    public static byte[] blowfishEncrypt(SecurityHelpers $this, byte[] plain, SecretKey key2) {
        return ((IoHelpers)((Object)$this)).readWholeStream($this.encryptStream((InputStream)new ByteArrayInputStream(plain), key2));
    }

    public static byte[] blowfishEncrypt(SecurityHelpers $this, byte[] plain, byte[] key2) {
        return $this.blowfishEncrypt(plain, $this.blowfishKeyFromBytes(key2));
    }

    public static String blowfishDecrypt(SecurityHelpers $this, String enc, SecretKey key2) {
        return new String($this.blowfishDecrypt($this.base64Decode(enc), key2), "UTF-8");
    }

    public static String blowfishDecrypt(SecurityHelpers $this, String enc, byte[] key2) {
        return $this.blowfishDecrypt(enc, $this.blowfishKeyFromBytes(key2));
    }

    public static byte[] blowfishDecrypt(SecurityHelpers $this, byte[] enc, SecretKey key2) {
        return ((IoHelpers)((Object)$this)).readWholeStream($this.decryptStream((InputStream)new ByteArrayInputStream(enc), key2));
    }

    public static byte[] blowfishDecrypt(SecurityHelpers $this, byte[] enc, byte[] key2) {
        return $this.blowfishDecrypt(enc, $this.blowfishKeyFromBytes(key2));
    }

    public static SecretKey blowfishKeyFromBytes(SecurityHelpers $this, byte[] key2) {
        return new SecretKeySpec(key2, "blowfish");
    }

    public static byte[] makeBlowfishKey(SecurityHelpers $this) {
        return KeyGenerator.getInstance("blowfish").generateKey().getEncoded();
    }

    public static boolean shouldShow(SecurityHelpers $this, double percent2) {
        return $this.net$liftweb$util$SecurityHelpers$$random().nextDouble() <= percent2;
    }

    public static int randomInt(SecurityHelpers $this, int mod) {
        return Math$.MODULE$.abs($this.net$liftweb$util$SecurityHelpers$$random().nextInt()) % mod;
    }

    public static long randomLong(SecurityHelpers $this, long mod) {
        return Math$.MODULE$.abs($this.net$liftweb$util$SecurityHelpers$$random().nextLong()) % mod;
    }
}

