/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.liftweb.common.Box;
import net.liftweb.common.Logger;
import net.liftweb.util.ConvertableToDate;
import net.liftweb.util.ConvertableToDate$;
import net.liftweb.util.TimeHelpers$TimeSpan$;
import net.liftweb.util.TimeHelpers$TimeSpanBuilder$;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.base.AbstractInstant;
import org.joda.time.base.BaseDateTime;
import org.joda.time.base.BaseDuration;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.Left;
import scala.MatchError;
import scala.Product;
import scala.Right;
import scala.ScalaObject;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface TimeHelpers
extends ScalaObject {
    public /* synthetic */ TimeHelpers$TimeSpanBuilder$ TimeSpanBuilder();

    public Box<Date> toDate(Object var1);

    public String nowAsInternetDate();

    public String toInternetDate(long var1);

    public String toInternetDate(Date var1);

    public Date parseInternetDate(String var1);

    public Box<Date> boxParseInternetDate(String var1);

    public SimpleDateFormat internetDateFormatter();

    public String formattedTimeNow();

    public String formattedDateNow();

    public SimpleDateFormat timeFormatter();

    public SimpleDateFormat dateFormatter();

    public String hourFormat(Date var1);

    public SimpleDateFormat hourFormat();

    public <T> T logTime(String var1, Function0<T> var2);

    public <T> Tuple2<Long, T> calcTime(Function0<T> var1);

    public long daysSinceEpoch();

    public long millisToDays(long var1);

    public TimeZone utc();

    public int day(Date var1);

    public int year(Date var1);

    public int month(Date var1);

    public Date time(long var1);

    public Date dayNow();

    public Date timeNow();

    public int currentYear();

    public Calendar today();

    public Date now();

    public CalendarExtension toCalendarExtension(Calendar var1);

    public DateExtension toDateExtension(Date var1);

    public long weeks(long var1);

    public long days(long var1);

    public long hours(long var1);

    public long minutes(long var1);

    public long seconds(long var1);

    public long millis();

    public long nano();

    public TimeHelpers$TimeSpan$ TimeSpan();

    public TimeSpan intToTimeSpan(int var1);

    public TimeSpan longToTimeSpan(long var1);

    public TimeSpanBuilder intToTimeSpanBuilder(int var1);

    public TimeSpanBuilder longToTimeSpanBuilder(long var1);

    public TimeHelpers net$liftweb$util$TimeHelpers$$outer();

    public Logger net$liftweb$util$TimeHelpers$$logger();

    public void utc_$eq(TimeZone var1);

    public void net$liftweb$util$TimeHelpers$$outer_$eq(TimeHelpers var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TimeSpan
    implements ConvertableToDate,
    ScalaObject {
        public final /* synthetic */ TimeHelpers $outer;
        private final Either<DateTime, Duration> dt;

        public TimeSpan(TimeHelpers $outer, Either<DateTime, Duration> dt) {
            this.dt = dt;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public /* synthetic */ TimeHelpers net$liftweb$util$TimeHelpers$TimeSpan$$$outer() {
            return this.$outer;
        }

        public String toString() {
            Either<DateTime, Duration> either;
            block4: {
                String string2;
                block3: {
                    block2: {
                        either = this.dt();
                        if (!(either instanceof Left)) break block2;
                        string2 = ((AbstractInstant)((Left)either).a()).toString();
                        break block3;
                    }
                    if (!(either instanceof Right)) break block4;
                    string2 = this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().TimeSpan().format(((BaseDuration)((Right)either).b()).getMillis());
                }
                return string2;
            }
            throw new MatchError(either);
        }

        public boolean equals(Object cmp) {
            boolean bl;
            Object object = cmp;
            if (object instanceof Long) {
                bl = BoxesRunTime.unboxToLong((Object)object) == this.millis();
            } else if (object instanceof Integer) {
                bl = (long)BoxesRunTime.unboxToInt((Object)object) == this.millis();
            } else if (object instanceof TimeSpan && ((TimeSpan)object).net$liftweb$util$TimeHelpers$TimeSpan$$$outer() == this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer()) {
                Either<DateTime, Duration> either = ((TimeSpan)object).dt();
                Either<DateTime, Duration> either2 = this.dt();
                bl = !(either != null ? !either.equals(either2) : either2 != null);
            } else if (object instanceof Date) {
                bl = ((Date)object).getTime() == this.millis();
            } else if (object instanceof DateTime) {
                Left left2 = new Left((Object)((DateTime)object));
                Either<DateTime, Duration> either = this.dt();
                bl = !(left2 != null ? !left2.equals(either) : either != null);
            } else if (object instanceof Duration) {
                Right right = new Right((Object)((Duration)object));
                Either<DateTime, Duration> either = this.dt();
                bl = !(right != null ? !right.equals(either) : either != null);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public <B> TimeSpan $minus(B in, Function1<B, TimeSpan> f) {
            TimeSpan timeSpan;
            Either<DateTime, Duration> either = this.dt();
            Either<DateTime, Duration> either2 = ((TimeSpan)f.apply(in)).dt();
            if (either instanceof Left) {
                Left left2 = (Left)either;
                DateTime dateTime = (DateTime)left2.a();
                if (either2 instanceof Right) {
                    timeSpan = this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().TimeSpan().dateTimeToTS(dateTime.minus((ReadableDuration)((Right)either2).b()));
                    return timeSpan;
                }
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Duration duration = (Duration)right.b();
                if (either2 instanceof Left) {
                    timeSpan = this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().TimeSpan().dateTimeToTS(((DateTime)((Left)either2).a()).minus((ReadableDuration)duration));
                    return timeSpan;
                }
            }
            timeSpan = this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().TimeSpan().apply(this.millis() - ((TimeSpan)f.apply(in)).millis());
            return timeSpan;
        }

        public <B> TimeSpan plus(B in, Function1<B, TimeSpan> f) {
            return this.$plus(in, f);
        }

        /*
         * Enabled aggressive block sorting
         */
        public <B> TimeSpan $plus(B in, Function1<B, TimeSpan> f) {
            TimeSpan timeSpan;
            Either<DateTime, Duration> either = this.dt();
            Either<DateTime, Duration> either2 = ((TimeSpan)f.apply(in)).dt();
            if (either instanceof Left) {
                Left left2 = (Left)either;
                DateTime dateTime = (DateTime)left2.a();
                if (either2 instanceof Right) {
                    timeSpan = this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().TimeSpan().dateTimeToTS(dateTime.plus((ReadableDuration)((Right)either2).b()));
                    return timeSpan;
                }
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Duration duration = (Duration)right.b();
                if (either2 instanceof Left) {
                    timeSpan = this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().TimeSpan().dateTimeToTS(((DateTime)((Left)either2).a()).plus((ReadableDuration)duration));
                    return timeSpan;
                }
            }
            timeSpan = this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().TimeSpan().apply(this.millis() + ((TimeSpan)f.apply(in)).millis());
            return timeSpan;
        }

        public Date noTime() {
            return this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().new DateExtension(ConvertableToDate$.MODULE$.toDate(this)).noTime();
        }

        public TimeSpan ago() {
            Either<DateTime, Duration> either = this.dt();
            return either instanceof Right ? new TimeSpan(this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer(), (Either<DateTime, Duration>)new Left((Object)new DateTime(this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().net$liftweb$util$TimeHelpers$$outer().millis()).minus((ReadableDuration)((Right)either).b()))) : this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().TimeSpan().apply(this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().net$liftweb$util$TimeHelpers$$outer().millis() - this.millis());
        }

        public TimeSpan later() {
            Either<DateTime, Duration> either = this.dt();
            return either instanceof Right ? new TimeSpan(this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer(), (Either<DateTime, Duration>)new Left((Object)new DateTime(this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().net$liftweb$util$TimeHelpers$$outer().millis()).plus((ReadableDuration)((Right)either).b()))) : this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().TimeSpan().apply(this.millis() + this.net$liftweb$util$TimeHelpers$TimeSpan$$$outer().net$liftweb$util$TimeHelpers$$outer().millis());
        }

        @Override
        public long millis() {
            Either<DateTime, Duration> either;
            block4: {
                long l;
                block3: {
                    block2: {
                        either = this.dt();
                        if (!(either instanceof Left)) break block2;
                        l = ((BaseDateTime)((Left)either).a()).getMillis();
                        break block3;
                    }
                    if (!(either instanceof Right)) break block4;
                    l = ((BaseDuration)((Right)either).b()).getMillis();
                }
                return l;
            }
            throw new MatchError(either);
        }

        public long toMillis() {
            return this.millis();
        }

        @Override
        public DateTime toDateTime() {
            Either<DateTime, Duration> either = this.dt();
            return either instanceof Left ? (DateTime)((Left)either).a() : new DateTime(this.millis());
        }

        @Override
        public Date toDate() {
            return this.date();
        }

        public Date date() {
            Either<DateTime, Duration> either = this.dt();
            return either instanceof Left ? new Date(((BaseDateTime)((Left)either).a()).getMillis()) : new Date(this.millis());
        }

        public TimeSpan(TimeHelpers $outer, long ms) {
            this($outer, (Either<DateTime, Duration>)(ms < 31449600000L ? new Right((Object)new Duration(ms)) : new Left((Object)new DateTime(ms))));
        }

        private Either<DateTime, Duration> dt() {
            return this.dt;
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }

    public class DateExtension
    implements ScalaObject {
        public DateExtension(Date date) {
            if (TimeHelpers.this == null) {
                throw new NullPointerException();
            }
        }

        public /* synthetic */ TimeHelpers net$liftweb$util$TimeHelpers$DateExtension$$$outer() {
            return TimeHelpers.this;
        }

        public Date noTime() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }

    public class TimeSpanBuilder
    implements ScalaObject,
    Product,
    Serializable {
        public final /* synthetic */ TimeHelpers $outer;
        private final long len;

        public TimeSpanBuilder(TimeHelpers $outer, long len) {
            this.len = len;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd1$1(long x$1) {
            return x$1 == this.len();
        }

        public /* synthetic */ TimeHelpers net$liftweb$util$TimeHelpers$TimeSpanBuilder$$$outer() {
            return this.$outer;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return BoxesRunTime.boxToLong((long)this.len());
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TimeSpanBuilder";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof TimeSpanBuilder && ((TimeSpanBuilder)object).net$liftweb$util$TimeHelpers$TimeSpanBuilder$$$outer() == this.net$liftweb$util$TimeHelpers$TimeSpanBuilder$$$outer() && this.gd1$1(((TimeSpanBuilder)object).len()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 1944871640;
        }

        public TimeSpan week() {
            return this.weeks();
        }

        public TimeSpan weeks() {
            return new TimeSpan(this.net$liftweb$util$TimeHelpers$TimeSpanBuilder$$$outer(), (Either<DateTime, Duration>)new Right((Object)Duration.standardDays((long)(this.len() * 7L))));
        }

        public TimeSpan day() {
            return this.days();
        }

        public TimeSpan days() {
            return new TimeSpan(this.net$liftweb$util$TimeHelpers$TimeSpanBuilder$$$outer(), (Either<DateTime, Duration>)new Right((Object)Duration.standardDays((long)this.len())));
        }

        public TimeSpan hour() {
            return this.hours();
        }

        public TimeSpan hours() {
            return new TimeSpan(this.net$liftweb$util$TimeHelpers$TimeSpanBuilder$$$outer(), (Either<DateTime, Duration>)new Right((Object)Duration.standardHours((long)this.len())));
        }

        public TimeSpan minute() {
            return this.minutes();
        }

        public TimeSpan minutes() {
            return new TimeSpan(this.net$liftweb$util$TimeHelpers$TimeSpanBuilder$$$outer(), (Either<DateTime, Duration>)new Right((Object)Duration.standardMinutes((long)this.len())));
        }

        public TimeSpan second() {
            return this.seconds();
        }

        public TimeSpan seconds() {
            return new TimeSpan(this.net$liftweb$util$TimeHelpers$TimeSpanBuilder$$$outer(), (Either<DateTime, Duration>)new Right((Object)Duration.standardSeconds((long)this.len())));
        }

        public long len() {
            return this.len;
        }
    }

    public class CalendarExtension
    implements ScalaObject {
        public final /* synthetic */ TimeHelpers $outer;
        private final Calendar c;

        public CalendarExtension(TimeHelpers $outer, Calendar c) {
            this.c = c;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public /* synthetic */ TimeHelpers net$liftweb$util$TimeHelpers$CalendarExtension$$$outer() {
            return this.$outer;
        }

        public Calendar noTime() {
            this.c.setTime(this.net$liftweb$util$TimeHelpers$CalendarExtension$$$outer().toDateExtension(this.c.getTime()).noTime());
            return this.c;
        }

        public Calendar setTimezone(TimeZone tz) {
            this.c.setTimeZone(tz);
            return this.c;
        }

        public Calendar setYear(int y) {
            this.c.set(1, y);
            return this.c;
        }

        public Calendar setMonth(int m) {
            this.c.set(2, m);
            return this.c;
        }

        public Calendar setDay(int d) {
            this.c.set(5, d);
            return this.c;
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }
}

