/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import net.liftweb.common.Box;
import net.liftweb.util.Currency$;
import net.liftweb.util.CurrencyMismatchException;
import net.liftweb.util.Helpers$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u0013\tA1)\u001e:sK:\u001c\u0017P\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!A\u0004mS\u001a$x/\u001a2\u000b\u0003\u001d\t1A\\3u\u0007\u0001\u00192\u0001\u0001\u0006\u0013!\tY\u0001#D\u0001\r\u0015\tia\"\u0001\u0003mC:<'\"A\b\u0002\t)\fg/Y\u0005\u0003#1\u0011aa\u00142kK\u000e$\bCA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u0007C6|WO\u001c;\u0016\u0003m\u0001\"a\u0005\u000f\n\u0005u!\"\u0001\u0002'p]\u001eD\u0001b\b\u0001\u0003\u0002\u0003\u0006IaG\u0001\bC6|WO\u001c;!\u0011!\t\u0003A!b\u0001\n\u0003\u0011\u0013AB:z[\n|G.F\u0001$!\t!sE\u0004\u0002\u0014K%\u0011a\u0005F\u0001\u0007!J,G-\u001a4\n\u0005!J#AB*ue&twM\u0003\u0002')!A1\u0006\u0001B\u0001B\u0003%1%A\u0004ts6\u0014w\u000e\u001c\u0011\t\u00115\u0002!Q1A\u0005\u00029\n\u0001\u0002Z3dS6\fGn]\u000b\u0002_A\u00111\u0003M\u0005\u0003cQ\u00111!\u00138u\u0011!\u0019\u0004A!A!\u0002\u0013y\u0013!\u00033fG&l\u0017\r\\:!\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019a\u0014N\\5u}Q!q'\u000f\u001e<!\tA\u0004!D\u0001\u0003\u0011\u0015IB\u00071\u0001\u001c\u0011\u0015\tC\u00071\u0001$\u0011\u0015iC\u00071\u00010\u0011\u0015i\u0004\u0001\"\u0011?\u0003!!xn\u0015;sS:<G#A \u0011\u0005-\u0001\u0015B\u0001\u0015\r\u0011\u0015\u0011\u0005\u0001\"\u0001#\u0003\u00151wN\u001d#C\u0011\u0015!\u0005\u0001\"\u0011F\u0003\u0019)\u0017/^1mgR\u0011a)\u0013\t\u0003'\u001dK!\u0001\u0013\u000b\u0003\u000f\t{w\u000e\\3b]\")!j\u0011a\u0001\u0017\u0006)q\u000e\u001e5feB\u00111\u0003T\u0005\u0003\u001bR\u00111!\u00118z\u0011\u0015y\u0005\u0001\"\u0001Q\u0003\u0015!\u0003\u000f\\;t)\t9\u0014\u000bC\u0003K\u001d\u0002\u0007q\u0007C\u0003T\u0001\u0011\u0005A+\u0001\u0004%[&tWo\u001d\u000b\u0003oUCQA\u0013*A\u0002]:Qa\u0016\u0002\t\u0006a\u000b\u0001bQ;se\u0016t7-\u001f\t\u0003qe3Q!\u0001\u0002\t\u0006i\u001b2!\u0017\u0006\u0013\u0011\u0015)\u0014\f\"\u0001])\u0005A\u0006\"\u00020Z\t\u0003y\u0016!B1qa2LHC\u00011g!\r\tGmN\u0007\u0002E*\u00111\rB\u0001\u0007G>lWn\u001c8\n\u0005\u0015\u0014'a\u0001\"pq\")q-\u0018a\u0001G\u0005\t1\u000f")
public class Currency
implements ScalaObject {
    private final long amount;
    private final String symbol;
    private final int decimals;

    public static final Box<Currency> apply(String string2) {
        return Currency$.MODULE$.apply(string2);
    }

    public long amount() {
        return this.amount;
    }

    public String symbol() {
        return this.symbol;
    }

    public int decimals() {
        return this.decimals;
    }

    public String toString() {
        String string2;
        if (this.decimals() == 0) {
            string2 = new StringBuilder().append((Object)this.symbol()).append((Object)BoxesRunTime.boxToLong((long)this.amount())).toString();
        } else {
            double d = this.amount();
            double pow = package$.MODULE$.pow(10.0, (double)this.decimals());
            string2 = new StringBuilder().append((Object)this.symbol()).append((Object)BoxesRunTime.boxToDouble((double)(d / pow))).toString();
        }
        return string2;
    }

    public String forDB() {
        return new StringBuilder().append((Object)Helpers$.MODULE$.urlEncode(this.symbol())).append((Object)"&").append((Object)BoxesRunTime.boxToLong((long)this.amount())).append((Object)"&").append((Object)BoxesRunTime.boxToInteger((int)this.decimals())).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof Currency)) return false;
        Currency currency = (Currency)object;
        Currency c = currency;
        if (c.amount() != this.amount()) return false;
        String string2 = c.symbol();
        String string3 = this.symbol();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        if (c.decimals() != this.decimals()) return false;
        return true;
    }

    public Currency $plus(Currency other) {
        String string2 = this.symbol();
        String string3 = other.symbol();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.decimals() == other.decimals()) {
            return new Currency(this.amount() + other.amount(), this.symbol(), this.decimals());
        }
        throw new CurrencyMismatchException();
    }

    public Currency $minus(Currency other) {
        String string2 = this.symbol();
        String string3 = other.symbol();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.decimals() == other.decimals()) {
            return new Currency(this.amount() - other.amount(), this.symbol(), this.decimals());
        }
        throw new CurrencyMismatchException();
    }

    public Currency(long amount, String symbol, int decimals) {
        this.amount = amount;
        this.symbol = symbol;
        this.decimals = decimals;
    }
}

