/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import java.security.MessageDigest;
import java.security.SecureRandom;
import net.liftweb.util.Helpers$;
import net.liftweb.util.SecurityHelpers;
import net.liftweb.util.StringHelpers;
import org.apache.commons.codec.binary.Base64;
import scala.Function1;
import scala.MatchError;
import scala.Math$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class SecurityHelpers$class {
    private static Object withRandom(StringHelpers $this, Function1 f) {
        SecureRandom secureRandom = ((SecurityHelpers)((Object)$this)).net$liftweb$util$SecurityHelpers$$_random();
        synchronized (secureRandom) {
            Object object = f.apply((Object)((SecurityHelpers)((Object)$this)).net$liftweb$util$SecurityHelpers$$_random());
            return object;
        }
    }

    public static long randomLong(StringHelpers $this, long mod$1) {
        return BoxesRunTime.unboxToLong((Object)SecurityHelpers$class.withRandom((StringHelpers)((Object)((SecurityHelpers)((Object)$this))), (Function1)new Serializable($this, mod$1){
            public static final long serialVersionUID;
            public final long mod$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply(SecureRandom random) {
                return Math$.MODULE$.abs(random.nextLong()) % this.mod$1;
            }
            {
                this.mod$1 = l;
            }
        }));
    }

    public static int randomInt(StringHelpers $this, int mod$2) {
        return BoxesRunTime.unboxToInt((Object)SecurityHelpers$class.withRandom((StringHelpers)((Object)((SecurityHelpers)((Object)$this))), (Function1)new Serializable($this, mod$2){
            public static final long serialVersionUID;
            public final int mod$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(SecureRandom random) {
                return Math$.MODULE$.abs(random.nextInt()) % this.mod$2;
            }
            {
                this.mod$2 = n;
            }
        }));
    }

    public static boolean shouldShow(StringHelpers $this, double percent$1) {
        return BoxesRunTime.unboxToBoolean((Object)SecurityHelpers$class.withRandom((StringHelpers)((Object)((SecurityHelpers)((Object)$this))), (Function1)new Serializable($this, percent$1){
            public static final long serialVersionUID;
            public final double percent$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(SecureRandom secureRandom) {
                return secureRandom.nextDouble() <= this.percent$1;
            }
            {
                this.percent$1 = d;
            }
        }));
    }

    private static final byte[] cleanArray(StringHelpers $this, byte[] in) {
        return (byte[])Predef$.MODULE$.byteArrayOps(in).filter((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(byte a) {
                return a >= 32 && a <= 127;
            }
        });
    }

    public static String base64Encode(StringHelpers $this, byte[] in) {
        return new String(SecurityHelpers$class.cleanArray((StringHelpers)((Object)((SecurityHelpers)((Object)$this))), new Base64().encode(in)));
    }

    public static String base64EncodeURLSafe(StringHelpers $this, byte[] in) {
        return new String(Base64.encodeBase64URLSafe((byte[])in));
    }

    public static byte[] base64Decode(StringHelpers $this, String in) {
        return new Base64().decode(in.getBytes("UTF-8"));
    }

    public static byte[] md5(StringHelpers $this, byte[] in) {
        return MessageDigest.getInstance("MD5").digest(in);
    }

    public static String md5(StringHelpers $this, String in) {
        return new String(SecurityHelpers$class.cleanArray((StringHelpers)((Object)((SecurityHelpers)((Object)$this))), new Base64().encode(((SecurityHelpers)((Object)$this)).md5(in.getBytes("UTF-8")))));
    }

    public static byte[] hash(StringHelpers $this, byte[] in) {
        return MessageDigest.getInstance("SHA").digest(in);
    }

    public static String hash(StringHelpers $this, String in) {
        return new String(SecurityHelpers$class.cleanArray((StringHelpers)((Object)((SecurityHelpers)((Object)$this))), new Base64().encode(MessageDigest.getInstance("SHA").digest(in.getBytes("UTF-8")))));
    }

    public static String hashHex(StringHelpers $this, String in) {
        return Helpers$.MODULE$.hexEncode(MessageDigest.getInstance("SHA").digest(in.getBytes("UTF-8")));
    }

    public static boolean secureEquals(StringHelpers $this, String s1, String s2) {
        Tuple2 tuple2 = new Tuple2((Object)s1, (Object)s2);
        if (tuple2 != null) {
            String string2 = (String)tuple2._1();
            String string3 = (String)tuple2._2();
            return string2 == null ? string3 == null : (string3 == null ? false : ((SecurityHelpers)((Object)$this)).secureEquals(string2.getBytes("UTF-8"), string3.getBytes("UTF-8")));
        }
        throw new MatchError((Object)tuple2);
    }

    public static boolean secureEquals(StringHelpers $this, byte[] s1, byte[] s2) {
        Tuple2 tuple2 = new Tuple2((Object)s1, (Object)s2);
        if (tuple2 != null) {
            boolean bl;
            byte[] byArray = (byte[])tuple2._1();
            byte[] byArray2 = (byte[])tuple2._2();
            if (byArray == null) {
                bl = byArray2 == null;
            } else if (byArray2 == null) {
                bl = false;
            } else {
                byte[] a = byArray;
                byte[] b = byArray2;
                int la = a.length;
                int lb = b.length;
                boolean ret = true;
                for (int pos = 0; pos < la && pos < lb; ++pos) {
                    ret &= a[pos] == b[pos];
                }
                bl = ret && la == lb;
            }
            return bl;
        }
        throw new MatchError((Object)tuple2);
    }

    public static byte[] hash256(StringHelpers $this, byte[] in) {
        return MessageDigest.getInstance("SHA-256").digest(in);
    }

    public static String hash256(StringHelpers $this, String in) {
        return new String(SecurityHelpers$class.cleanArray((StringHelpers)((Object)((SecurityHelpers)((Object)$this))), new Base64().encode(MessageDigest.getInstance("SHA-256").digest(in.getBytes("UTF-8")))));
    }

    public static String hexDigest(StringHelpers $this, byte[] in) {
        byte[] binHash = MessageDigest.getInstance("SHA").digest(in);
        return ((SecurityHelpers)((Object)$this)).hexEncode(binHash);
    }

    public static String hexDigest256(StringHelpers $this, byte[] in) {
        byte[] binHash = MessageDigest.getInstance("SHA-256").digest(in);
        return ((SecurityHelpers)((Object)$this)).hexEncode(binHash);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] hexDecode(StringHelpers $this, String str) {
        void var3_3;
        int max2 = str.length() / 2;
        byte[] ret = new byte[max2];
        for (int pos = 0; pos < max2; ++pos) {
            int two = pos * 2;
            char ch = str.charAt(two);
            char cl = str.charAt(two + 1);
            ret[pos] = (byte)(SecurityHelpers$class.byteOf$1($this, ch) * 16 + SecurityHelpers$class.byteOf$1($this, cl));
        }
        return var3_3;
    }

    public static String hexEncode(StringHelpers $this, byte[] in) {
        StringBuilder sb = new StringBuilder();
        int len = in.length;
        SecurityHelpers$class.addDigit$1($this, in, 0, len, sb);
        return sb.toString();
    }

    private static final int byteOf$1(StringHelpers $this, char in) {
        int n;
        char c = in;
        switch (c) {
            default: {
                n = 0;
                break;
            }
            case 'd': {
                n = 13;
                break;
            }
            case 'D': {
                n = 13;
                break;
            }
            case '3': {
                n = 3;
                break;
            }
            case '7': {
                n = 7;
                break;
            }
            case 'c': {
                n = 12;
                break;
            }
            case 'C': {
                n = 12;
                break;
            }
            case '2': {
                n = 2;
                break;
            }
            case '0': {
                n = 0;
                break;
            }
            case 'B': {
                n = 11;
                break;
            }
            case 'b': {
                n = 11;
                break;
            }
            case '1': {
                n = 1;
                break;
            }
            case '6': {
                n = 6;
                break;
            }
            case '5': {
                n = 5;
                break;
            }
            case 'a': {
                n = 10;
                break;
            }
            case 'A': {
                n = 10;
                break;
            }
            case 'F': {
                n = 15;
                break;
            }
            case 'f': {
                n = 15;
                break;
            }
            case '9': {
                n = 9;
                break;
            }
            case '4': {
                n = 4;
                break;
            }
            case '8': {
                n = 8;
                break;
            }
            case 'e': {
                n = 14;
                break;
            }
            case 'E': {
                n = 14;
            }
        }
        return n;
    }

    private static final void addDigit$1(StringHelpers $this, byte[] in, int pos, int len, StringBuilder sb) {
        while (pos < len) {
            byte b = in[pos];
            int msb = (b & 0xF0) >> 4;
            int lsb = b & 0xF;
            sb.append(msb < 10 ? (char)(48 + msb) : (char)(97 + (msb - 10)));
            sb.append(lsb < 10 ? (char)(48 + lsb) : (char)(97 + (lsb - 10)));
            ++pos;
        }
    }

    public static void $init$(StringHelpers $this) {
        ((SecurityHelpers)((Object)$this)).net$liftweb$util$SecurityHelpers$_setter_$net$liftweb$util$SecurityHelpers$$_random_$eq(new SecureRandom());
    }
}

